/*
 * Decompiled with CFR 0.152.
 */
package alfio.util;

import java.time.Duration;
import java.time.LocalTime;

public class HoursRange {
    private final LocalTime start;
    private final LocalTime end;

    public HoursRange(LocalTime start, LocalTime end) {
        this.start = start;
        this.end = end;
    }

    public boolean includes(LocalTime localTime) {
        return Duration.between(localTime, this.start).isNegative() && Duration.between(this.end, localTime).isNegative();
    }

    public int getDistanceInHours(LocalTime localTime) {
        if (this.includes(localTime)) {
            return 0;
        }
        Duration distanceFromStart = Duration.between(localTime, this.start);
        if (distanceFromStart.isNegative()) {
            return 24 + (int)distanceFromStart.toHours();
        }
        return (int)distanceFromStart.toHours();
    }
}

