/*
 * Decompiled with CFR 0.152.
 */
package alfio.util;

import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;

/*
 * Exception performing whole class analysis ignored.
 */
public final class HttpUtils {
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_JSON_UTF8 = "application/json;charset=UTF-8";
    public static final String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String AUTHORIZATION = "Authorization";

    private HttpUtils() {
    }

    public static boolean callSuccessful(HttpResponse<?> response) {
        return HttpUtils.statusCodeIsSuccessful((int)response.statusCode());
    }

    public static boolean statusCodeIsSuccessful(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    public static HttpResponse<String> postForm(HttpClient httpClient, String url, Map<String, String> params) throws IOException, InterruptedException {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpUtils.ofFormUrlEncodedBody(params)).build();
        return httpClient.send(request, HttpResponse.BodyHandlers.ofString());
    }

    public static String basicAuth(String username, String password) {
        return "Basic " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes(StandardCharsets.UTF_8));
    }

    public static <K, V> HttpRequest.BodyPublisher ofFormUrlEncodedBody(Map<K, V> data) {
        Objects.requireNonNull(data);
        StringBuilder sb = new StringBuilder();
        data.forEach((k, v) -> {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(URLEncoder.encode(k.toString(), StandardCharsets.UTF_8)).append("=").append(URLEncoder.encode(v.toString(), StandardCharsets.UTF_8));
        });
        return HttpRequest.BodyPublishers.ofString(sb.toString());
    }
}

