/*
 * Decompiled with CFR 0.152.
 */
package alfio.util;

import alfio.manager.FileUploadManager;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumMap;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ImageUtil {
    private static final Logger log = LoggerFactory.getLogger(ImageUtil.class);
    private static final String DEJA_VU_SANS_MONO = "/alfio/font/DejaVuSansMono.ttf";
    private static final String DEJA_VU_SANS = "/alfio/font/DejaVuSans.ttf";
    private static final String DEJA_VU_SERIF = "/alfio/font/DejaVuSerif.ttf";
    private static final String FONT_SECTION = "font";

    private static File loadDejaVuFont(String name) {
        try {
            File cachedFile = File.createTempFile("font-cache", ".tmp");
            try (InputStream is = new ClassPathResource(name).getInputStream();
                 FileOutputStream tmpOs = new FileOutputStream(cachedFile);){
                is.transferTo(tmpOs);
            }
            return cachedFile;
        }
        catch (IOException e) {
            log.warn("error while loading DejaVuSansMono.ttf font", (Throwable)e);
            return null;
        }
    }

    public static File getDejaVuSansMonoFont(FileUploadManager fileUploadManager) {
        return fileUploadManager.getFile("font", "DejaVuSansMono", () -> ImageUtil.loadDejaVuFont((String)"/alfio/font/DejaVuSansMono.ttf"));
    }

    public static File getDejaVuSansFont(FileUploadManager fileUploadManager) {
        return fileUploadManager.getFile("font", "DejaVuSans", () -> ImageUtil.loadDejaVuFont((String)"/alfio/font/DejaVuSans.ttf"));
    }

    public static File getDejaVuSerifFont(FileUploadManager fileUploadManager) {
        return fileUploadManager.getFile("font", "DejaVuSerif", () -> ImageUtil.loadDejaVuFont((String)"/alfio/font/DejaVuSerif.ttf"));
    }

    private ImageUtil() {
    }

    public static byte[] createQRCode(String text) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BitMatrix matrix = ImageUtil.drawQRCode((String)text);
            MatrixToImageWriter.writeToStream((BitMatrix)matrix, (String)"png", (OutputStream)baos);
            return baos.toByteArray();
        }
        catch (WriterException | IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static BitMatrix drawQRCode(String text) throws WriterException {
        EnumMap<EncodeHintType, ErrorCorrectionLevel> hintMap = new EnumMap<EncodeHintType, ErrorCorrectionLevel>(EncodeHintType.class);
        hintMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        return new MultiFormatWriter().encode(text, BarcodeFormat.QR_CODE, 200, 200, hintMap);
    }

    public static byte[] createQRCodeWithDescription(String text, String description, FileUploadManager fileUploadManager) {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            BitMatrix matrix = ImageUtil.drawQRCode((String)text);
            BufferedImage bufferedImage = MatrixToImageWriter.toBufferedImage((BitMatrix)matrix);
            BufferedImage scaled = new BufferedImage(200, 230, 2);
            Graphics2D graphics = (Graphics2D)scaled.getGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics.drawImage((Image)bufferedImage, 0, 0, null);
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 200, 200, 30);
            graphics.setColor(Color.BLACK);
            File fontFile = ImageUtil.getDejaVuSansMonoFont((FileUploadManager)fileUploadManager);
            if (fontFile != null) {
                graphics.setFont(Font.createFont(0, fontFile).deriveFont(14.0f));
                graphics.drawString(StringUtils.center((String)StringUtils.truncate((String)description, (int)23), (int)25), 0, 215);
            }
            ImageIO.write((RenderedImage)scaled, "png", baos);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (WriterException | FontFormatException | IOException e) {
                throw new IllegalStateException(e);
            }
        }
        baos.close();
        return byArray;
    }
}

