/*
 * Decompiled with CFR 0.152.
 */
package alfio.util;

import alfio.util.ItalianTaxIdValidator;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ItalianTaxIdValidator {
    private static final char[] CONTROL_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final String VOWELS = "AEIOU";
    private static final int COMPANY_TAX_ID_LENGTH = 11;
    private static final Map<Character, EvenOddValueContainer> VALUES = Map.ofEntries(Map.entry(Character.valueOf('A'), new EvenOddValueContainer(0, 1)), Map.entry(Character.valueOf('B'), new EvenOddValueContainer(1, 0)), Map.entry(Character.valueOf('C'), new EvenOddValueContainer(2, 5)), Map.entry(Character.valueOf('D'), new EvenOddValueContainer(3, 7)), Map.entry(Character.valueOf('E'), new EvenOddValueContainer(4, 9)), Map.entry(Character.valueOf('F'), new EvenOddValueContainer(5, 13)), Map.entry(Character.valueOf('G'), new EvenOddValueContainer(6, 15)), Map.entry(Character.valueOf('H'), new EvenOddValueContainer(7, 17)), Map.entry(Character.valueOf('I'), new EvenOddValueContainer(8, 19)), Map.entry(Character.valueOf('J'), new EvenOddValueContainer(9, 21)), Map.entry(Character.valueOf('K'), new EvenOddValueContainer(10, 2)), Map.entry(Character.valueOf('L'), new EvenOddValueContainer(11, 4)), Map.entry(Character.valueOf('M'), new EvenOddValueContainer(12, 18)), Map.entry(Character.valueOf('N'), new EvenOddValueContainer(13, 20)), Map.entry(Character.valueOf('O'), new EvenOddValueContainer(14, 11)), Map.entry(Character.valueOf('P'), new EvenOddValueContainer(15, 3)), Map.entry(Character.valueOf('Q'), new EvenOddValueContainer(16, 6)), Map.entry(Character.valueOf('R'), new EvenOddValueContainer(17, 8)), Map.entry(Character.valueOf('S'), new EvenOddValueContainer(18, 12)), Map.entry(Character.valueOf('T'), new EvenOddValueContainer(19, 14)), Map.entry(Character.valueOf('U'), new EvenOddValueContainer(20, 16)), Map.entry(Character.valueOf('V'), new EvenOddValueContainer(21, 10)), Map.entry(Character.valueOf('W'), new EvenOddValueContainer(22, 22)), Map.entry(Character.valueOf('X'), new EvenOddValueContainer(23, 25)), Map.entry(Character.valueOf('Y'), new EvenOddValueContainer(24, 24)), Map.entry(Character.valueOf('Z'), new EvenOddValueContainer(25, 23)), Map.entry(Character.valueOf('0'), new EvenOddValueContainer(0, 1)), Map.entry(Character.valueOf('1'), new EvenOddValueContainer(1, 0)), Map.entry(Character.valueOf('2'), new EvenOddValueContainer(2, 5)), Map.entry(Character.valueOf('3'), new EvenOddValueContainer(3, 7)), Map.entry(Character.valueOf('4'), new EvenOddValueContainer(4, 9)), Map.entry(Character.valueOf('5'), new EvenOddValueContainer(5, 13)), Map.entry(Character.valueOf('6'), new EvenOddValueContainer(6, 15)), Map.entry(Character.valueOf('7'), new EvenOddValueContainer(7, 17)), Map.entry(Character.valueOf('8'), new EvenOddValueContainer(8, 19)), Map.entry(Character.valueOf('9'), new EvenOddValueContainer(9, 21)));

    private ItalianTaxIdValidator() {
    }

    public static boolean validateFiscalCode(String fiscalCode) {
        String code = StringUtils.upperCase((String)StringUtils.trimToNull((String)fiscalCode));
        int length = StringUtils.length((CharSequence)code);
        if (length == 11) {
            return ItalianTaxIdValidator.validateVatId((String)fiscalCode);
        }
        if (StringUtils.isBlank((CharSequence)code) || length != 16) {
            return false;
        }
        char[] chars = code.toCharArray();
        int sum = 0;
        for (int i = 0; i < chars.length - 1; ++i) {
            EvenOddValueContainer valueContainer = Objects.requireNonNull((EvenOddValueContainer)VALUES.get(Character.valueOf(chars[i])));
            sum += valueContainer.getValue(i);
        }
        return chars[15] == CONTROL_CHARS[sum % 26];
    }

    public static boolean fiscalCodeMatchesWithName(String firstName, String lastName, String fiscalCode) {
        if (ItalianTaxIdValidator.validateFiscalCode((String)fiscalCode)) {
            if (StringUtils.length((CharSequence)fiscalCode) == 11) {
                return true;
            }
            StringBuilder code = new StringBuilder();
            FiscalCodeParts lastNameParts = ItalianTaxIdValidator.parseFiscalCodePart((String)lastName.trim());
            ItalianTaxIdValidator.appendLastNameCode((StringBuilder)code, (FiscalCodeParts)lastNameParts);
            FiscalCodeParts firstNameParts = ItalianTaxIdValidator.parseFiscalCodePart((String)firstName.trim());
            int numConsonants = firstNameParts.consonants.size();
            if (numConsonants < 4) {
                ItalianTaxIdValidator.appendLastNameCode((StringBuilder)code, (FiscalCodeParts)firstNameParts);
            } else {
                ArrayList<Character> consonantsList = new ArrayList<Character>();
                consonantsList.add((Character)firstNameParts.consonants.get(0));
                consonantsList.addAll(firstNameParts.consonants.subList(2, firstNameParts.consonants.size()));
                ItalianTaxIdValidator.appendLastNameCode((StringBuilder)code, (FiscalCodeParts)new FiscalCodeParts(consonantsList, firstNameParts.vowels));
            }
            return fiscalCode.toUpperCase(Locale.ITALIAN).startsWith(code.toString());
        }
        return false;
    }

    private static void appendLastNameCode(StringBuilder code, FiscalCodeParts lastNameParts) {
        lastNameParts.consonants.stream().limit(3L).forEach(code::append);
        int chars = code.length();
        if (chars < 3) {
            lastNameParts.vowels.stream().limit(3L - (long)chars).forEach(code::append);
        }
        chars = code.length();
        code.append("X".repeat(Math.max(0, 3 - chars)));
    }

    private static FiscalCodeParts parseFiscalCodePart(String part) {
        char[] chars = StringUtils.stripAccents((String)part.toUpperCase(Locale.ITALIAN)).toCharArray();
        ArrayList<Character> consonants = new ArrayList<Character>();
        ArrayList<Character> vowels = new ArrayList<Character>();
        for (char c : chars) {
            if (!Character.isAlphabetic(c)) continue;
            if ("AEIOU".indexOf(c) > -1) {
                vowels.add(Character.valueOf(c));
                continue;
            }
            consonants.add(Character.valueOf(c));
        }
        return new FiscalCodeParts(consonants, vowels);
    }

    public static boolean validateVatId(String vatId) {
        String nr = StringUtils.trimToNull((String)vatId);
        if (nr == null || StringUtils.length((CharSequence)nr) != 11 && !StringUtils.isNumeric((CharSequence)nr)) {
            return false;
        }
        int sumEven = 0;
        int sumOdd = 0;
        char[] chars = nr.toCharArray();
        if (chars.length != 11) {
            return false;
        }
        for (int i = 0; i < 10; ++i) {
            int val = Character.getNumericValue(chars[i]);
            if ((i + 1) % 2 == 0) {
                int product = val * 2;
                sumOdd += product > 9 ? product - 9 : product;
                continue;
            }
            sumEven += val;
        }
        int controlDigit = (sumEven + sumOdd) % 10;
        if (controlDigit > 0) {
            controlDigit = 10 - controlDigit;
        }
        return controlDigit == Character.getNumericValue(chars[10]);
    }
}

