/*
 * Decompiled with CFR 0.152.
 */
package alfio.util;

import alfio.model.ContentLanguage;
import alfio.model.LocalizedContent;
import alfio.model.Ticket;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class LocaleUtil {
    private LocaleUtil() {
    }

    public static Locale getTicketLanguage(Ticket t, Locale fallbackLocale) {
        return Optional.ofNullable(t.getUserLanguage()).filter(StringUtils::isNotBlank).map(Locale::forLanguageTag).orElse(fallbackLocale);
    }

    public static Locale forLanguageTag(String lang) {
        if (lang == null) {
            return Locale.ENGLISH;
        }
        return Locale.forLanguageTag(lang);
    }

    public static Locale forLanguageTag(String lang, LocalizedContent localizedContent) {
        String cleanedUpLang = StringUtils.trimToEmpty((String)lang).toLowerCase(Locale.ENGLISH);
        String filteredLang = localizedContent.getContentLanguages().stream().filter(l -> cleanedUpLang.equalsIgnoreCase(l.getLanguage())).findFirst().map(ContentLanguage::getLanguage).orElseGet(() -> localizedContent.getContentLanguages().stream().findFirst().map(ContentLanguage::getLanguage).orElse("en"));
        return LocaleUtil.forLanguageTag((String)filteredLang);
    }

    public static ZonedDateTime atZone(ZonedDateTime in, ZoneId zone) {
        if (in != null) {
            return in.withZoneSameInstant(zone);
        }
        return null;
    }

    public static ZonedDateTime atZone(LocalDateTime in, ZoneId zone) {
        if (in != null) {
            return in.atZone(Objects.requireNonNull(zone));
        }
        return null;
    }

    public static Map<String, String> formatDate(ZonedDateTime date, Map<Locale, String> datePatterns) {
        if (date == null) {
            return null;
        }
        return datePatterns.entrySet().stream().map(dp -> Map.entry(((Locale)dp.getKey()).getLanguage(), DateTimeFormatter.ofPattern((String)dp.getValue()).format(date))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

