/*
 * Decompiled with CFR 0.152.
 */
package alfio.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.joda.money.CurrencyUnit;

/*
 * Exception performing whole class analysis ignored.
 */
public final class MonetaryUtil {
    public static final BigDecimal HUNDRED = new BigDecimal("100.00");
    private static final int ROUNDING_SCALE = 10;

    private MonetaryUtil() {
    }

    public static int addVAT(int priceInCents, BigDecimal vat) {
        return MonetaryUtil.addVAT((BigDecimal)new BigDecimal(priceInCents), (BigDecimal)vat).intValueExact();
    }

    private static BigDecimal addVAT(BigDecimal price, BigDecimal vat) {
        return price.add(price.multiply(vat.divide(HUNDRED, 10, RoundingMode.UP))).setScale(0, RoundingMode.HALF_UP);
    }

    public static BigDecimal extractVAT(BigDecimal price, BigDecimal vat) {
        return price.subtract(price.divide(BigDecimal.ONE.add(vat.divide(HUNDRED, 10, RoundingMode.UP)), 10, RoundingMode.HALF_DOWN));
    }

    public static <T extends Number> T calcPercentage(long priceInCents, BigDecimal vat, Function<BigDecimal, T> converter) {
        BigDecimal result = new BigDecimal(priceInCents).multiply(vat.divide(HUNDRED, 10, RoundingMode.UP)).setScale(0, RoundingMode.HALF_UP);
        return (T)((Number)converter.apply(result));
    }

    public static BigDecimal calcVat(BigDecimal price, BigDecimal percentage) {
        return price.multiply(percentage.divide(HUNDRED, 10, RoundingMode.HALF_UP));
    }

    public static BigDecimal centsToUnit(int cents, String currencyCode) {
        return MonetaryUtil.centsToUnit((long)cents, (String)currencyCode);
    }

    public static BigDecimal centsToUnit(long cents, String currencyCode) {
        return MonetaryUtil.centsToUnit((long)cents, (String)currencyCode, (boolean)false);
    }

    public static BigDecimal centsToUnit(long cents, String currencyCode, boolean formatZero) {
        if (cents == 0L && !formatZero || StringUtils.isEmpty((CharSequence)currencyCode)) {
            return BigDecimal.ZERO;
        }
        CurrencyUnit currencyUnit = CurrencyUnit.of((String)currencyCode.toUpperCase(Locale.ENGLISH));
        int scale = currencyUnit.getDecimalPlaces();
        return new BigDecimal(cents).divide(BigDecimal.TEN.pow(scale), scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal fixScale(BigDecimal raw, String currencyCode) {
        CurrencyUnit currencyUnit = CurrencyUnit.of((String)currencyCode.toUpperCase(Locale.ENGLISH));
        return raw.setScale(currencyUnit.getDecimalPlaces(), RoundingMode.HALF_UP);
    }

    public static int unitToCents(BigDecimal unit, String currencyCode) {
        if (StringUtils.isEmpty((CharSequence)currencyCode)) {
            return 0;
        }
        return (Integer)MonetaryUtil.unitToCents((BigDecimal)unit, (String)currencyCode, BigDecimal::intValueExact);
    }

    public static <T extends Number> T unitToCents(BigDecimal unit, String currencyCode, Function<BigDecimal, T> converter) {
        int scale = StringUtils.isEmpty((CharSequence)currencyCode) ? 2 : CurrencyUnit.of((String)currencyCode.toUpperCase(Locale.ENGLISH)).getDecimalPlaces();
        BigDecimal result = unit.multiply(BigDecimal.TEN.pow(scale)).setScale(0, RoundingMode.HALF_UP);
        return (T)((Number)converter.apply(result));
    }

    public static String formatCents(int cents, String currencyCode) {
        return MonetaryUtil.formatCents((long)cents, (String)currencyCode);
    }

    public static String formatCents(long cents, String currencyCode, boolean formatZero) {
        if (StringUtils.isEmpty((CharSequence)currencyCode)) {
            return "0";
        }
        return MonetaryUtil.centsToUnit((long)cents, (String)currencyCode, (boolean)formatZero).toPlainString();
    }

    public static String formatCents(long cents, String currencyCode) {
        return MonetaryUtil.formatCents((long)cents, (String)currencyCode, (boolean)false);
    }

    public static String formatUnit(BigDecimal unit, String currencyCode) {
        if (StringUtils.isEmpty((CharSequence)currencyCode)) {
            return "0";
        }
        CurrencyUnit currencyUnit = CurrencyUnit.of((String)Objects.requireNonNull(currencyCode).toUpperCase(Locale.ENGLISH));
        return Objects.requireNonNull(unit).setScale(currencyUnit.getDecimalPlaces(), RoundingMode.HALF_UP).toPlainString();
    }

    public static String formatPercentage(int percentageCts) {
        return MonetaryUtil.formatPercentage((BigDecimal)new BigDecimal(percentageCts).divide(HUNDRED, RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP));
    }

    public static String formatPercentage(BigDecimal unit) {
        return unit.stripTrailingZeros().toPlainString();
    }
}

