/*
 * Decompiled with CFR 0.152.
 */
package alfio.util;

import alfio.controller.api.support.TicketHelper;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.util.LocaleUtil;
import alfio.util.MustacheCustomTag;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import java.io.IOException;
import java.io.Writer;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.text.StringEscapeUtils;
import org.commonmark.Extension;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.commonmark.renderer.text.TextContentRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;

/*
 * Exception performing whole class analysis ignored.
 */
public class MustacheCustomTag {
    public static final String SUBSCRIPTION_DESCRIPTOR_ATTRIBUTE = "subscriptionDescriptor";
    private static final Logger log = LoggerFactory.getLogger(MustacheCustomTag.class);
    private static final Pattern ARG_PATTERN = Pattern.compile("\\[(.*?)]");
    private static final String LOCALE_LABEL = "locale:";
    static final Mustache.Lambda FORMAT_DATE = (frag, out) -> {
        String execution = frag.execute().trim();
        String dateAsString = StringUtils.substring((String)execution, (int)0, (int)execution.indexOf(32)).trim();
        boolean isDateTime = dateAsString.length() > 10;
        Comparable<ChronoZonedDateTime<?>> date = isDateTime ? ZonedDateTime.parse(dateAsString) : LocalDate.parse(dateAsString);
        Pair p = MustacheCustomTag.parseParams((String)execution);
        if (((Optional)p.getRight()).isPresent()) {
            out.write(DateTimeFormatter.ofPattern((String)p.getLeft(), (Locale)((Optional)p.getRight()).get()).format((TemporalAccessor)((Object)date)));
        } else {
            out.write(DateTimeFormatter.ofPattern((String)p.getLeft()).format((TemporalAccessor)((Object)date)));
        }
    };
    static final Mustache.Lambda RENDER_MARKDOWN = (frag, out) -> {
        String execution = frag.execute().strip();
        if (execution.endsWith(".html")) {
            out.write(MustacheCustomTag.renderToHtmlCommonmark((String)StringUtils.removeEnd((String)execution, (String)".html"), null));
        } else if (execution.endsWith(".text")) {
            out.write(MustacheCustomTag.renderToTextCommonmark((String)StringUtils.removeEnd((String)execution, (String)".text")));
        } else {
            out.write(execution);
        }
    };
    static final Mustache.Lambda COUNTRY_NAME = (frag, out) -> {
        String execution = frag.execute().trim();
        String code = StringUtils.substring((String)execution, (int)0, (int)2);
        Pair p = MustacheCustomTag.parseParams((String)execution);
        out.write(MustacheCustomTag.translateCountryCode((String)code, (Locale)((Optional)p.getRight()).orElse(null)));
    };
    static final Function<Object, Mustache.Lambda> ADDITIONAL_FIELD_VALUE = obj -> (frag, out) -> {
        String suffix;
        if (!(obj instanceof Map) || ((Map)obj).isEmpty()) {
            log.warn("map not found or empty. Skipping additionalFieldValue tag");
            return;
        }
        Map fieldNamesAndValues = (Map)obj;
        String execution = frag.execute().trim();
        Matcher matcher = ARG_PATTERN.matcher(execution);
        ArrayList<String> args = new ArrayList<String>();
        while (matcher.find()) {
            args.add(matcher.group(1));
        }
        if (args.isEmpty()) {
            return;
        }
        String name = (String)args.get(args.size() > 1 ? 1 : 0);
        String prefix = args.size() > 1 ? (String)args.get(0) + " " : "";
        String string = suffix = args.size() > 2 ? " " + (String)args.get(2) : "";
        if (fieldNamesAndValues.containsKey(name)) {
            out.write(prefix + fieldNamesAndValues.get(name) + suffix);
        }
    };
    static final BiFunction<Object, Supplier<Map<String, String>>, Mustache.Lambda> PRINT_ADDITIONAL_FIELDS = (obj, descriptionSupplier) -> (arg_0, arg_1) -> MustacheCustomTag.lambda$static$7(obj, (Supplier)descriptionSupplier, arg_0, arg_1);
    private static final List<Extension> COMMONMARK_EXTENSIONS = List.of(TablesExtension.create());
    private static final Parser COMMONMARK_PARSER = Parser.builder().extensions((Iterable)COMMONMARK_EXTENSIONS).build();
    private static final HtmlRenderer COMMONMARK_RENDERER = HtmlRenderer.builder().extensions((Iterable)COMMONMARK_EXTENSIONS).attributeProviderFactory(ctx -> new TargetBlankProvider()).build();
    private static final TextContentRenderer COMMONMARK_TEXT_RENDERER = TextContentRenderer.builder().extensions((Iterable)COMMONMARK_EXTENSIONS).build();
    private static final ThreadLocal<String> A11Y_NEW_TAB_LABEL = new ThreadLocal();

    private MustacheCustomTag() {
    }

    static String translateCountryCode(String code, Locale locale) {
        Locale lang = locale != null ? locale : Locale.ENGLISH;
        return Stream.concat(TicketHelper.getLocalizedCountries((Locale)lang).stream(), TicketHelper.getLocalizedCountriesForVat((Locale)lang).stream()).filter(p -> ((String)p.getKey()).equalsIgnoreCase(code)).map(Pair::getValue).findFirst().orElse(code);
    }

    static Mustache.Lambda subscriptionDescriptionGenerator(MessageSource messageSource, Map<String, Object> model, Locale locale) {
        return (frag, out) -> {
            SubscriptionDescriptor subscriptionDescriptor = (SubscriptionDescriptor)Objects.requireNonNull(model.get("subscriptionDescriptor"));
            String usageType = messageSource.getMessage("subscription.usage-type." + subscriptionDescriptor.getUsageType(), null, locale);
            switch (1.$SwitchMap$alfio$model$subscription$SubscriptionDescriptor$SubscriptionValidityType[subscriptionDescriptor.getValidityType().ordinal()]) {
                case 1: {
                    Object[] standardParams = new Object[]{subscriptionDescriptor.getValidityUnits(), messageSource.getMessage("subscription.time-unit." + subscriptionDescriptor.getValidityTimeUnit(), null, locale), usageType};
                    out.write(messageSource.getMessage("subscription.detail.validity.STANDARD.description", standardParams, locale));
                    break;
                }
                case 2: {
                    Object[] notSetParams = new Object[]{subscriptionDescriptor.getMaxEntries(), messageSource.getMessage("subscription.usage-type." + subscriptionDescriptor.getUsageType(), null, locale), usageType};
                    out.write(messageSource.getMessage("subscription.detail.validity.NOT_SET.description", notSetParams, locale));
                    break;
                }
                case 3: {
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern(messageSource.getMessage("common.event.date-format", null, locale));
                    out.write(messageSource.getMessage("subscription.detail.validity.CUSTOM.from", null, locale));
                    out.write(" " + formatter.format(subscriptionDescriptor.getValidityFrom()));
                    out.write(messageSource.getMessage("subscription.detail.validity.CUSTOM.to", null, locale));
                    out.write(" " + formatter.format(subscriptionDescriptor.getValidityTo()));
                    out.write(" - " + usageType);
                }
            }
        };
    }

    private static Pair<String, Optional<Locale>> parseParams(String r) {
        int indexLocale = r.indexOf("locale:");
        int end = Math.min(r.length(), indexLocale != -1 ? indexLocale : r.length());
        String format = StringUtils.substring((String)r, (int)r.indexOf(32), (int)end);
        String[] res = r.split("\\s+");
        Optional<Locale> locale = Arrays.stream(res).filter(s -> s.startsWith("locale:")).findFirst().map(l -> LocaleUtil.forLanguageTag((String)StringUtils.substring((String)l, (int)"locale:".length())));
        return Pair.of((Object)format, locale);
    }

    public static String renderToHtmlCommonmarkEscaped(String input) {
        return MustacheCustomTag.renderToHtmlCommonmarkEscaped((String)input, null);
    }

    private static Optional<String> getScheme(String uri) {
        String s = StringUtils.trimToEmpty((String)uri).toLowerCase(Locale.ROOT);
        return s.indexOf(58) >= 0 ? Optional.of(StringUtils.substringBefore((String)s, (int)58)) : Optional.empty();
    }

    public static String renderToHtmlCommonmarkEscaped(String input, String localizedNewWindowLabel) {
        return MustacheCustomTag.renderToHtmlCommonmark((String)StringEscapeUtils.escapeHtml4((String)input), (String)localizedNewWindowLabel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String renderToHtmlCommonmark(String input, String localizedNewWindowLabel) {
        try {
            A11Y_NEW_TAB_LABEL.set(localizedNewWindowLabel);
            Node document = COMMONMARK_PARSER.parse(input);
            String string = COMMONMARK_RENDERER.render(document);
            return string;
        }
        finally {
            A11Y_NEW_TAB_LABEL.remove();
        }
    }

    public static String renderToTextCommonmark(String input) {
        Node document = COMMONMARK_PARSER.parse(input);
        return COMMONMARK_TEXT_RENDERER.render(document);
    }

    private static /* synthetic */ void lambda$static$7(Object obj, Supplier descriptionSupplier, Template.Fragment frag, Writer out) throws IOException {
        if (!(obj instanceof Map) || ((Map)obj).isEmpty()) {
            log.warn("map not found or empty. Skipping additionalFieldValue tag");
            return;
        }
        Map originalContext = (Map)frag.context();
        Map descriptionsByFieldName = (Map)descriptionSupplier.get();
        for (Map.Entry entry : ((Map)obj).entrySet()) {
            HashMap<String, String> context = new HashMap<String, String>(originalContext);
            String key2 = String.valueOf(entry.getKey());
            String label = (String)StringUtils.defaultIfBlank((CharSequence)((String)descriptionsByFieldName.get(key2)), (CharSequence)key2);
            context.put("fieldName", label);
            context.put("fieldValue", String.valueOf(entry.getValue()));
            out.write(frag.execute(context));
        }
        ((Map)obj).forEach((key, value) -> {});
    }
}

