/*
 * Decompiled with CFR 0.152.
 */
package alfio.util;

import alfio.model.Ticket;
import alfio.util.ObjectDiffUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ReflectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ObjectDiffUtil {
    public static <T> List<Change> diff(Map<String, T> before, Map<String, T> after) {
        return ObjectDiffUtil.diffUntyped(before, after, (String)"/{", (String)"}");
    }

    private static String formatPropertyName(String k, String propertyNameBefore, String propertyNameAfter) {
        return propertyNameBefore + k + propertyNameAfter;
    }

    private static List<Change> diffUntyped(Map<String, ?> before, Map<String, ?> after, String propertyNameBefore, String propertyNameAfter) {
        HashSet<String> removed = new HashSet<String>(before.keySet());
        removed.removeAll(after.keySet());
        HashSet<String> added = new HashSet<String>(after.keySet());
        added.removeAll(before.keySet());
        HashSet<String> changedOrUntouched = new HashSet<String>(after.keySet());
        changedOrUntouched.removeAll(removed);
        changedOrUntouched.removeAll(added);
        ArrayList<Change> changes = new ArrayList<Change>();
        removed.stream().map(k -> new Change(ObjectDiffUtil.formatPropertyName((String)k, (String)propertyNameBefore, (String)propertyNameAfter), State.REMOVED, before.get(k), null)).forEach(changes::add);
        added.stream().map(k -> new Change(ObjectDiffUtil.formatPropertyName((String)k, (String)propertyNameBefore, (String)propertyNameAfter), State.ADDED, null, after.get(k))).forEach(changes::add);
        changedOrUntouched.forEach(k -> {
            Object afterValue;
            Object beforeValue = before.get(k);
            if (!Objects.equals(beforeValue, afterValue = after.get(k))) {
                changes.add(new Change(ObjectDiffUtil.formatPropertyName((String)k, (String)propertyNameBefore, (String)propertyNameAfter), State.CHANGED, beforeValue, afterValue));
            }
        });
        changes.sort(Change::compareTo);
        return changes;
    }

    public static List<Change> diff(Ticket before, Ticket after) {
        return ObjectDiffUtil.diff((Object)before, (Object)after, Ticket.class);
    }

    public static <T> List<Change> diff(T before, T after, Class<T> objectType) {
        HashMap beforeAsMap = new HashMap();
        HashMap afterAsMap = new HashMap();
        Stream.of(BeanUtils.getPropertyDescriptors(objectType)).forEach(propertyDescriptor -> {
            Method method = propertyDescriptor.getReadMethod();
            String name = propertyDescriptor.getName();
            if (method != null) {
                beforeAsMap.put(name, ReflectionUtils.invokeMethod((Method)method, (Object)before));
                afterAsMap.put(name, ReflectionUtils.invokeMethod((Method)method, (Object)after));
            }
        });
        return ObjectDiffUtil.diffUntyped(beforeAsMap, afterAsMap, (String)"/", (String)"");
    }
}

