/*
 * Decompiled with CFR 0.152.
 */
package alfio.util;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import java.util.function.IntConsumer;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

public final class PasswordGenerator {
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final char[] PASSWORD_CHARACTERS;
    private static final boolean DEV_MODE;
    private static final int MAX_LENGTH = 20;
    private static final int MIN_LENGTH = 10;
    private static final Pattern VALIDATION_PATTERN;

    private PasswordGenerator() {
    }

    public static String generateRandomPassword() {
        if (DEV_MODE) {
            return "abcd";
        }
        int length = 10 + RANDOM.nextInt(11);
        return RandomStringUtils.random((int)length, (int)0, (int)PASSWORD_CHARACTERS.length, (boolean)false, (boolean)false, (char[])PASSWORD_CHARACTERS, (Random)RANDOM);
    }

    public static boolean isValid(String password) {
        return StringUtils.isNotBlank((CharSequence)password) && VALIDATION_PATTERN.matcher(password).matches();
    }

    static {
        ArrayList<Character> chars = new ArrayList<Character>();
        IntConsumer addToList = c -> chars.add(Character.valueOf((char)c));
        IntStream.rangeClosed(97, 122).forEach(addToList);
        IntStream.rangeClosed(65, 90).forEach(addToList);
        IntStream.rangeClosed(48, 57).forEach(addToList);
        chars.add(Character.valueOf('#'));
        chars.add(Character.valueOf('~'));
        chars.add(Character.valueOf('!'));
        chars.add(Character.valueOf('-'));
        chars.add(Character.valueOf('_'));
        chars.add(Character.valueOf('/'));
        chars.add(Character.valueOf('^'));
        chars.add(Character.valueOf('&'));
        chars.add(Character.valueOf('+'));
        chars.add(Character.valueOf('%'));
        chars.add(Character.valueOf('('));
        chars.add(Character.valueOf(')'));
        chars.add(Character.valueOf('='));
        PASSWORD_CHARACTERS = ArrayUtils.toPrimitive((Character[])chars.toArray(new Character[0]));
        DEV_MODE = Arrays.stream(Optional.ofNullable(System.getProperty("spring.profiles.active")).map(p -> p.split(",")).orElse(new String[0])).map(StringUtils::trim).anyMatch("dev"::equals);
        VALIDATION_PATTERN = Pattern.compile("^(?=.*[0-9])(?=.*[a-z])(?=.*[A-Z])(?=.*\\p{Punct})(?=\\S+$).{10,}$");
    }
}

