/*
 * Decompiled with CFR 0.152.
 */
package alfio.util;

import java.math.BigInteger;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
public class PinGenerator {
    private static final String ALLOWED_CHARS = "ACDEFGHJKLMNPQRTUVWXY34679";
    private static final Pattern VALIDATION_PATTERN = Pattern.compile("^[ACDEFGHJKLMNPQRTUVWXY34679]+$");
    private static final int PIN_LENGTH = 6;

    private PinGenerator() {
    }

    public static String uuidToPin(String uuid, int pinLength) {
        BigInteger src = new BigInteger(uuid.replace("-", "").substring(0, pinLength + 1), 16);
        BigInteger chars = BigInteger.valueOf("ACDEFGHJKLMNPQRTUVWXY34679".length());
        StringBuilder pin = new StringBuilder();
        do {
            BigInteger remainder = src.mod(chars);
            pin.append("ACDEFGHJKLMNPQRTUVWXY34679".charAt(remainder.intValue()));
        } while (!(src = src.divide(chars)).equals(BigInteger.ZERO));
        while (pin.length() < pinLength) {
            pin.append("ACDEFGHJKLMNPQRTUVWXY34679".charAt(0));
        }
        return pin.reverse().toString();
    }

    public static String pinToPartialUuid(String pin, int pinLength) {
        Assert.isTrue((boolean)PinGenerator.isPinValid((String)pin, (int)pinLength), (String)"the given PIN is not valid");
        String uppercasePin = Objects.requireNonNull(pin).strip().toUpperCase();
        BigInteger base = BigInteger.valueOf("ACDEFGHJKLMNPQRTUVWXY34679".length());
        BigInteger num = BigInteger.ZERO;
        for (int i = 0; i < pin.length(); ++i) {
            char c = uppercasePin.charAt(pin.length() - 1 - i);
            BigInteger toAdd = BigInteger.valueOf("ACDEFGHJKLMNPQRTUVWXY34679".indexOf(c)).multiply(base.pow(i));
            num = num.add(toAdd);
        }
        return StringUtils.leftPad((String)num.toString(16), (int)(pinLength + 1), (char)'0');
    }

    public static boolean isPinValid(String pin, int pinLength) {
        return pin != null && (pin.strip().length() == pinLength || pin.strip().length() == pinLength + 1) && VALIDATION_PATTERN.matcher(pin.toUpperCase()).matches();
    }

    public static String uuidToPin(String uuid) {
        return PinGenerator.uuidToPin((String)uuid, (int)6);
    }

    public static String pinToPartialUuid(String pin) {
        return PinGenerator.pinToPartialUuid((String)pin, (int)6);
    }

    public static boolean isPinValid(String pin) {
        return PinGenerator.isPinValid((String)pin, (int)6);
    }
}

