/*
 * Decompiled with CFR 0.152.
 */
package alfio.util;

import alfio.model.TicketCategoryStatisticView;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.apache.commons.lang3.tuple.Pair;

public final class PreReservedTicketDistributor
implements Collector<Pair<Integer, TicketCategoryStatisticView>, List<Pair<Integer, TicketCategoryStatisticView>>, List<Pair<Integer, TicketCategoryStatisticView>>> {
    private final AtomicInteger requestedTickets;

    public PreReservedTicketDistributor(int requestedTickets) {
        this.requestedTickets = new AtomicInteger(requestedTickets);
    }

    @Override
    public Supplier<List<Pair<Integer, TicketCategoryStatisticView>>> supplier() {
        return ArrayList::new;
    }

    @Override
    public BiConsumer<List<Pair<Integer, TicketCategoryStatisticView>>, Pair<Integer, TicketCategoryStatisticView>> accumulator() {
        return (accumulator, candidate) -> {
            int requested = this.requestedTickets.get();
            if (requested > 0) {
                int capacity = Math.min(requested, (Integer)candidate.getKey());
                accumulator.add(Pair.of((Object)capacity, (Object)((TicketCategoryStatisticView)candidate.getValue())));
                this.requestedTickets.addAndGet(-capacity);
            }
        };
    }

    @Override
    public BinaryOperator<List<Pair<Integer, TicketCategoryStatisticView>>> combiner() {
        return (a, b) -> a;
    }

    @Override
    public Function<List<Pair<Integer, TicketCategoryStatisticView>>, List<Pair<Integer, TicketCategoryStatisticView>>> finisher() {
        return Function.identity();
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return EnumSet.of(Collector.Characteristics.IDENTITY_FINISH);
    }
}

