/*
 * Decompiled with CFR 0.152.
 */
package alfio.util;

import alfio.model.ContentLanguage;
import alfio.model.Event;
import alfio.util.LocaleUtil;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.IteratorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.web.context.request.ServletWebRequest;

/*
 * Exception performing whole class analysis ignored.
 */
public class RequestUtils {
    private static final Logger log = LoggerFactory.getLogger(RequestUtils.class);
    private static final Pattern SOCIAL_MEDIA_UA = Pattern.compile("facebookexternalhit/|XING-contenttabreceiver/|LinkedInBot/|Twitterbot/|WhatsApp|Slackbot|TelegramBot");

    private RequestUtils() {
    }

    public static Optional<String> readRequest(HttpServletRequest request) {
        Optional<String> optional;
        block8: {
            ServletInputStream is = request.getInputStream();
            try {
                optional = Optional.ofNullable(is.readAllBytes()).map(b -> new String((byte[])b, StandardCharsets.UTF_8));
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("exception during request conversion", (Throwable)e);
                    return Optional.empty();
                }
            }
            is.close();
        }
        return optional;
    }

    public static boolean isSocialMediaShareUA(String ua) {
        return ua != null && SOCIAL_MEDIA_UA.matcher(ua).find();
    }

    public static Locale getMatchingLocale(ServletWebRequest request, List<String> allowedLanguages) {
        Enumeration l = Objects.requireNonNull((HttpServletRequest)request.getNativeRequest(HttpServletRequest.class)).getLocales();
        List locales = l != null ? IteratorUtils.toList(l.asIterator()) : Collections.emptyList();
        String selectedLocale = locales.stream().map(Locale::getLanguage).filter(allowedLanguages::contains).findFirst().orElseGet(() -> (String)allowedLanguages.stream().findFirst().orElseThrow());
        return LocaleUtil.forLanguageTag((String)selectedLocale);
    }

    public static Locale getMatchingLocale(ServletWebRequest request, Event event) {
        List allowedLanguages = event.getContentLanguages().stream().map(ContentLanguage::getLanguage).collect(Collectors.toList());
        return RequestUtils.getMatchingLocale((ServletWebRequest)request, allowedLanguages);
    }

    public static boolean isAdmin(Principal principal) {
        if (principal instanceof Authentication) {
            Authentication authentication = (Authentication)principal;
            return RequestUtils.hasRole((Authentication)authentication, (String)"ROLE_ADMIN");
        }
        return false;
    }

    private static boolean hasRole(Authentication principal, String role) {
        return principal.getAuthorities().stream().map(GrantedAuthority::getAuthority).anyMatch(role::equals);
    }

    public static boolean isSystemApiKey(Principal principal) {
        if (principal instanceof Authentication) {
            Authentication authentication = (Authentication)principal;
            return RequestUtils.hasRole((Authentication)authentication, (String)"ROLE_SYSTEM_API_CLIENT");
        }
        return false;
    }
}

