/*
 * Decompiled with CFR 0.152.
 */
package alfio.util;

import alfio.controller.decorator.SaleableTicketCategory;
import alfio.controller.form.ReservationCreate;
import alfio.manager.AdditionalServiceManager;
import alfio.manager.EventManager;
import alfio.manager.PromoCodeRequestManager;
import alfio.manager.TicketReservationManager;
import alfio.manager.support.reservation.CannotProceedWithPayment;
import alfio.manager.support.reservation.InvalidSpecialPriceTokenException;
import alfio.manager.support.reservation.MissingSpecialPriceTokenException;
import alfio.manager.support.reservation.NotEnoughItemsException;
import alfio.manager.support.reservation.NotEnoughTicketsException;
import alfio.manager.support.reservation.TooManyTicketsForDiscountCodeException;
import alfio.manager.support.response.ValidatedResponse;
import alfio.manager.system.ConfigurationManager;
import alfio.model.AdditionalService;
import alfio.model.CategoryAvailability;
import alfio.model.Event;
import alfio.model.EventAndOrganizationId;
import alfio.model.PromoCodeDiscount;
import alfio.model.PurchaseContext;
import alfio.model.SpecialPrice;
import alfio.model.Ticket;
import alfio.model.TicketCategory;
import alfio.model.TicketReservation;
import alfio.model.TicketWithCategory;
import alfio.model.modification.ASReservationWithOptionalCodeModification;
import alfio.model.modification.AdditionalServiceReservationModification;
import alfio.model.modification.ReservationRequest;
import alfio.model.modification.TicketReservationWithOptionalCodeModification;
import alfio.repository.TicketCategoryRepository;
import alfio.util.ClockProvider;
import alfio.util.LocaleUtil;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;

/*
 * Exception performing whole class analysis ignored.
 */
public class ReservationUtil {
    private static final Logger log = LoggerFactory.getLogger(ReservationUtil.class);

    private ReservationUtil() {
    }

    public static <T extends ReservationRequest> Optional<String> checkPromoCode(ReservationCreate<T> createRequest, Event event, PromoCodeRequestManager promoCodeRequestManager, BindingResult bindingResult) {
        Optional<ValidatedResponse> codeCheck = Optional.empty();
        if (StringUtils.trimToNull((String)createRequest.getPromoCode()) != null) {
            ValidatedResponse resCheck = promoCodeRequestManager.checkCode(event, createRequest.getPromoCode());
            if (!resCheck.isSuccess()) {
                bindingResult.reject("error.STEP_1_CODE_NOT_FOUND", "error.STEP_1_CODE_NOT_FOUND");
            }
            codeCheck = Optional.of(resCheck);
        }
        return codeCheck.map(ValidatedResponse::getValue).flatMap(Pair::getRight).map(PromoCodeDiscount::getPromoCode);
    }

    public static Optional<Pair<List<TicketReservationWithOptionalCodeModification>, List<ASReservationWithOptionalCodeModification>>> validateCreateRequest(ReservationCreate<? extends ReservationRequest> request, Errors bindingResult, TicketReservationManager tickReservationManager, EventManager eventManager, AdditionalServiceManager additionalServiceManager, String validatedPromoCodeDiscount, Event event) {
        int selectionCount = ReservationUtil.ticketSelectionCount((List)request.getTickets());
        if (selectionCount <= 0) {
            bindingResult.reject("error.STEP_1_SELECT_AT_LEAST_ONE");
            return Optional.empty();
        }
        List<Pair> maxTicketsByTicketReservation = ReservationUtil.selected((List)request.getTickets()).stream().map(r -> Pair.of((Object)r, (Object)tickReservationManager.maxAmountOfTicketsForCategory((EventAndOrganizationId)event, r.getTicketCategoryId().intValue(), validatedPromoCodeDiscount))).toList();
        Optional<Pair> error = maxTicketsByTicketReservation.stream().filter(p -> ((ReservationRequest)p.getKey()).getQuantity() > (Integer)p.getValue()).findAny();
        if (error.isPresent()) {
            bindingResult.reject("error.STEP_1_OVER_MAXIMUM", new Object[]{error.get().getValue()}, null);
            return Optional.empty();
        }
        Set selectedCategoryIds = ReservationUtil.selected((List)request.getTickets()).stream().map(ReservationRequest::getTicketCategoryId).collect(Collectors.toSet());
        Set availableCategoryIds = eventManager.findCategoriesById(selectedCategoryIds, (EventAndOrganizationId)event).stream().map(TicketCategory::getId).collect(Collectors.toSet());
        boolean validCategorySelection = availableCategoryIds.equals(selectedCategoryIds);
        List additionalServices = ReservationUtil.selectedAdditionalServices((List)request.getAdditionalServices());
        boolean validAdditionalServiceSelected = additionalServices.stream().allMatch(asm -> {
            AdditionalService as = additionalServiceManager.getAdditionalServiceById(asm.getAdditionalServiceId().intValue(), event.getId());
            ZonedDateTime now = event.now(ClockProvider.clock());
            return as.getInception(event.getZoneId()).isBefore(now) && as.getExpiration(event.getZoneId()).isAfter(now) && asm.getQuantity() >= 0 && (as.fixPrice() && asm.isQuantityValid(as, selectionCount) || !as.fixPrice() && asm.getAmount() != null && asm.getAmount().compareTo(BigDecimal.ZERO) >= 0) && eventManager.eventExistsById(as.eventId());
        });
        if (!validCategorySelection || !validAdditionalServiceSelected) {
            bindingResult.reject("error.STEP_1_TICKET_CATEGORY_MUST_BE_SALEABLE");
            return Optional.empty();
        }
        ArrayList res = new ArrayList();
        Optional specialCode = Optional.ofNullable(StringUtils.trimToNull((String)request.getPromoCode())).flatMap(arg_0 -> ((TicketReservationManager)tickReservationManager).getSpecialPriceByCode(arg_0));
        ZonedDateTime now = event.now(ClockProvider.clock());
        maxTicketsByTicketReservation.forEach(pair -> ReservationUtil.validateCategory((Errors)bindingResult, (TicketReservationManager)tickReservationManager, (EventManager)eventManager, (Event)event, (int)((Integer)pair.getRight()), (List)res, (Optional)specialCode, (ZonedDateTime)now, (ReservationRequest)((ReservationRequest)pair.getLeft())));
        return bindingResult.hasErrors() ? Optional.empty() : Optional.of(Pair.of(res, additionalServices.stream().map(as -> new ASReservationWithOptionalCodeModification(as, specialCode)).toList()));
    }

    private static <T extends ReservationRequest> int ticketSelectionCount(List<T> tickets) {
        return ReservationUtil.selected(tickets).stream().mapToInt(ReservationRequest::getQuantity).sum();
    }

    private static <T extends ReservationRequest> void validateCategory(Errors bindingResult, TicketReservationManager tickReservationManager, EventManager eventManager, Event event, int maxAmountOfTicket, List<TicketReservationWithOptionalCodeModification> res, Optional<SpecialPrice> specialCode, ZonedDateTime now, T r) {
        CategoryAvailability categoryAvailability;
        TicketCategory tc = eventManager.getTicketCategoryById(r.getTicketCategoryId().intValue(), event.getId());
        SaleableTicketCategory ticketCategory = new SaleableTicketCategory(tc, now, event, categoryAvailability = tickReservationManager.countAvailableTickets((EventAndOrganizationId)event, tc), maxAmountOfTicket, null);
        if (!ticketCategory.getSaleable()) {
            bindingResult.reject("error.STEP_1_TICKET_CATEGORY_MUST_BE_SALEABLE");
            return;
        }
        res.add(new TicketReservationWithOptionalCodeModification(r, ticketCategory.isAccessRestricted() ? specialCode : Optional.empty()));
    }

    private static <T extends ReservationRequest> List<T> selected(List<T> reservation) {
        return Optional.ofNullable(reservation).orElse(Collections.emptyList()).stream().filter(e -> e != null && e.getQuantity() != null && e.getTicketCategoryId() != null && e.getQuantity() > 0).toList();
    }

    private static List<AdditionalServiceReservationModification> selectedAdditionalServices(List<AdditionalServiceReservationModification> additionalServices) {
        return Optional.ofNullable(additionalServices).orElse(Collections.emptyList()).stream().filter(e -> e != null && e.getQuantity() != null && e.getAdditionalServiceId() != null && e.getQuantity() > 0).toList();
    }

    public static boolean hasPrivacyPolicy(PurchaseContext event) {
        return StringUtils.isNotBlank((CharSequence)event.getPrivacyPolicyLinkOrNull());
    }

    public static String ticketUpdateUrl(Event event, Ticket ticket, ConfigurationManager configurationManager) {
        return configurationManager.baseUrl((PurchaseContext)event) + "/event/" + event.getShortName() + "/ticket/" + ticket.getPublicUuid().toString() + "/update?lang=" + ticket.getUserLanguage();
    }

    public static String reservationUrl(String baseUrl, String reservationId, PurchaseContext purchaseContext, String userLanguage, String additionalParams) {
        String cleanParams = StringUtils.trimToNull((String)additionalParams);
        return StringUtils.removeEnd((String)baseUrl, (String)"/") + "/" + purchaseContext.getType() + "/" + purchaseContext.getPublicIdentifier() + "/reservation/" + reservationId + "?lang=" + userLanguage + (String)(cleanParams != null ? "&" + cleanParams : "");
    }

    public static String reservationUrl(String baseUrl, String reservationId, PurchaseContext purchaseContext, String userLanguage) {
        return ReservationUtil.reservationUrl((String)baseUrl, (String)reservationId, (PurchaseContext)purchaseContext, (String)userLanguage, null);
    }

    public static String reservationUrl(TicketReservation reservation, PurchaseContext purchaseContext, ConfigurationManager configurationManager) {
        return ReservationUtil.reservationUrl((String)configurationManager.baseUrl(purchaseContext), (String)reservation.getId(), (PurchaseContext)purchaseContext, (String)reservation.getUserLanguage());
    }

    public static List<TicketWithCategory> collectTicketsWithCategory(Map<Integer, List<Ticket>> ticketsByCategory, TicketCategoryRepository ticketCategoryRepository) {
        List<Object> ticketsWithCategory = !ticketsByCategory.isEmpty() ? ticketCategoryRepository.findByIds(ticketsByCategory.keySet()).stream().flatMap(tc -> ((List)ticketsByCategory.get(tc.getId())).stream().map(t -> new TicketWithCategory(t, tc))).toList() : Collections.emptyList();
        return ticketsWithCategory;
    }

    public static Locale getReservationLocale(TicketReservation reservation) {
        return StringUtils.isEmpty((CharSequence)reservation.getUserLanguage()) ? Locale.ENGLISH : LocaleUtil.forLanguageTag((String)reservation.getUserLanguage());
    }

    public static Optional<String> handleReservationCreationErrors(Supplier<Optional<String>> reservationCreationCall, BindingResult bindingResult, PurchaseContext.PurchaseContextType purchaseContextType) {
        try {
            return reservationCreationCall.get();
        }
        catch (NotEnoughItemsException | NotEnoughTicketsException nete) {
            if (purchaseContextType == PurchaseContext.PurchaseContextType.event) {
                bindingResult.reject("error.STEP_1_NOT_ENOUGH_TICKETS");
            } else {
                log.error("cannot acquire subscription", nete);
                bindingResult.reject("show-subscription.sold-out.message");
            }
        }
        catch (MissingSpecialPriceTokenException missing) {
            bindingResult.reject("error.STEP_1_ACCESS_RESTRICTED");
        }
        catch (InvalidSpecialPriceTokenException invalid) {
            bindingResult.reject("error.STEP_1_CODE_NOT_FOUND");
        }
        catch (TooManyTicketsForDiscountCodeException tooMany) {
            bindingResult.reject("error.STEP2_DISCOUNT_CODE_USAGE_EXCEEDED");
        }
        catch (CannotProceedWithPayment cannotProceedWithPayment) {
            bindingResult.reject("error.STEP_1_CATEGORIES_NOT_COMPATIBLE");
            log.error("missing payment methods", (Throwable)cannotProceedWithPayment);
        }
        return Optional.empty();
    }
}

