/*
 * Decompiled with CFR 0.152.
 */
package alfio.util;

import alfio.util.ClockProvider;
import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.postgresql.util.PSQLException;
import org.postgresql.util.ServerErrorMessage;
import org.springframework.jdbc.UncategorizedSQLException;

public class SqlUtils {
    private SqlUtils() {
    }

    public static Optional<ServerErrorMessage> findServerError(UncategorizedSQLException exception) {
        for (Throwable throwable : exception.getSQLException()) {
            PSQLException lException;
            if (!(throwable instanceof PSQLException) || (lException = (PSQLException)throwable).getServerErrorMessage() == null) continue;
            return Optional.ofNullable(lException.getServerErrorMessage());
        }
        return Optional.empty();
    }

    public static ZonedDateTime timestampToZoneDateTime(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        return ZonedDateTime.ofInstant(timestamp.toInstant(), ClockProvider.clock().getZone());
    }
}

