/*
 * Decompiled with CFR 0.152.
 */
package alfio.util;

import alfio.manager.PurchaseContextFieldManager;
import alfio.manager.UploadedResourceManager;
import alfio.manager.i18n.MessageSourceManager;
import alfio.manager.system.ConfigurationLevel;
import alfio.manager.system.ConfigurationManager;
import alfio.model.EventAndOrganizationId;
import alfio.model.PurchaseContext;
import alfio.model.PurchaseContextFieldDescription;
import alfio.model.system.ConfigurationKeys;
import alfio.util.MustacheCustomTag;
import alfio.util.RenderedTemplate;
import alfio.util.TemplateManager;
import alfio.util.TemplateResource;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.ModelAndView;

public class TemplateManager {
    public static final String METADATA_ATTRIBUTES_KEY = "metadata-attributes";
    public static final String ADDITIONAL_FIELDS_KEY = "additional-fields";
    public static final String VAT_TRANSLATION_TEMPLATE_KEY = "vatTranslation";
    public static final String MAIL_FOOTER = "mailFooter";
    private static final Logger log = LoggerFactory.getLogger(TemplateManager.class);
    private final MessageSourceManager messageSourceManager;
    private final Map<TemplateOutput, Mustache.Compiler> compilers;
    private final UploadedResourceManager uploadedResourceManager;
    private final ConfigurationManager configurationManager;
    private final PurchaseContextFieldManager purchaseContextFieldManager;
    private static final Pattern KEY_PATTERN = Pattern.compile("^([^\\[]+)[\\s\\[]");
    private static final Pattern ARGS_PATTERN = Pattern.compile("\\[(.*?)]");
    private static final String START_TAG = "{{#i18n}}";
    private static final String END_TAG = "{{/i18n}}";

    public TemplateManager(MessageSourceManager messageSourceManager, UploadedResourceManager uploadedResourceManager, ConfigurationManager configurationManager, PurchaseContextFieldManager purchaseContextFieldManager) {
        this.messageSourceManager = messageSourceManager;
        this.uploadedResourceManager = uploadedResourceManager;
        this.configurationManager = configurationManager;
        this.purchaseContextFieldManager = purchaseContextFieldManager;
        this.compilers = new EnumMap(TemplateOutput.class);
        this.compilers.put(TemplateOutput.TEXT, Mustache.compiler().escapeHTML(false).standardsMode(false).defaultValue("").nullValue("").withFormatter(TemplateManager::dateFormatter));
        this.compilers.put(TemplateOutput.HTML, Mustache.compiler().escapeHTML(true).standardsMode(false).defaultValue("").nullValue("").withFormatter(TemplateManager::dateFormatter));
    }

    private static String dateFormatter(Object o) {
        if (o instanceof ZonedDateTime) {
            ZonedDateTime time = (ZonedDateTime)o;
            return DateTimeFormatter.ISO_ZONED_DATE_TIME.format(time);
        }
        return String.valueOf(o);
    }

    private RenderedTemplate renderMultipartTemplate(PurchaseContext purchaseContext, TemplateResource templateResource, Map<String, Object> model, Locale locale) {
        Map enrichedModel = this.modelEnricher(model, purchaseContext, locale);
        Map options = this.configurationManager.getFor(EnumSet.of(ConfigurationKeys.MAIL_FOOTER, ConfigurationKeys.ENABLE_HTML_EMAILS), purchaseContext.getConfigurationLevel());
        ConfigurationManager.MaybeConfiguration mailFooter = (ConfigurationManager.MaybeConfiguration)options.get(ConfigurationKeys.MAIL_FOOTER);
        enrichedModel.put("hasMailFooter", mailFooter.isPresent());
        enrichedModel.put(MAIL_FOOTER, mailFooter.getValueOrNull());
        boolean isMultipart = templateResource.isMultipart();
        String textRender = this.render((Resource)new ClassPathResource(templateResource.classPath()), enrichedModel, locale, purchaseContext, isMultipart ? TemplateOutput.TEXT : templateResource.getTemplateOutput());
        boolean htmlEnabled = ((ConfigurationManager.MaybeConfiguration)options.get(ConfigurationKeys.ENABLE_HTML_EMAILS)).getValueAsBooleanOrDefault();
        String htmlRender = null;
        if (isMultipart && htmlEnabled) {
            htmlRender = this.render((Resource)new ClassPathResource(templateResource.htmlClassPath()), enrichedModel, locale, purchaseContext, TemplateOutput.HTML);
        }
        return RenderedTemplate.multipart((String)textRender, htmlRender, model);
    }

    public RenderedTemplate renderTemplate(PurchaseContext purchaseContext, TemplateResource templateResource, Map<String, Object> model, Locale locale) {
        Map updatedModel = this.modelEnricher(model, purchaseContext, locale);
        return this.uploadedResourceManager.findCascading(purchaseContext.getOrganizationId(), (Integer)purchaseContext.event().map(EventAndOrganizationId::getId).orElse(null), templateResource.getSavedName(locale)).map(resource -> RenderedTemplate.plaintext((String)this.render((Resource)new ByteArrayResource(templateResource.replaceTokens(resource)), updatedModel, locale, purchaseContext, templateResource.getTemplateOutput()), (Map)model)).orElseGet(() -> this.renderMultipartTemplate(purchaseContext, templateResource, updatedModel, locale));
    }

    public String renderString(PurchaseContext purchaseContext, String template, Map<String, Object> model, Locale locale, TemplateOutput templateOutput) {
        return this.render((Resource)new ByteArrayResource(template.getBytes(StandardCharsets.UTF_8)), this.modelEnricher(model, purchaseContext, locale), locale, purchaseContext, templateOutput);
    }

    public void renderHtml(Resource resource, Map<String, Object> model, OutputStream os) {
        try (OutputStreamWriter osw = new OutputStreamWriter(os, StandardCharsets.UTF_8);){
            this.compile(resource, TemplateOutput.HTML).execute(model, (Writer)osw);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    public void renderHtml(Resource resource, Map<String, Object> model, Writer out) {
        this.compile(resource, TemplateOutput.HTML).execute(model, out);
    }

    private Map<String, Object> modelEnricher(Map<String, Object> model, PurchaseContext purchaseContext, Locale locale) {
        HashMap<String, Object> toEnrich = new HashMap<String, Object>(model);
        if (!toEnrich.containsKey("purchaseContext")) {
            toEnrich.put("purchaseContext", purchaseContext);
        }
        toEnrich.put(VAT_TRANSLATION_TEMPLATE_KEY, this.messageSourceManager.getMessageSourceFor(purchaseContext).getMessage("common.vat", null, locale));
        return toEnrich;
    }

    private String render(Resource resource, Map<String, Object> model, Locale locale, PurchaseContext purchaseContext, TemplateOutput templateOutput) {
        try {
            MessageSource messageSource = this.messageSourceManager.getMessageSourceFor(purchaseContext);
            Map configuration = this.configurationManager.getFor(EnumSet.of(ConfigurationKeys.USE_PARTNER_CODE_INSTEAD_OF_PROMOTIONAL, ConfigurationKeys.ENABLE_WALLET, ConfigurationKeys.ENABLE_PASS), ConfigurationLevel.purchaseContext((PurchaseContext)purchaseContext));
            boolean usePartnerCode = Objects.requireNonNull((ConfigurationManager.MaybeConfiguration)configuration.get(ConfigurationKeys.USE_PARTNER_CODE_INSTEAD_OF_PROMOTIONAL)).getValueAsBooleanOrDefault();
            Supplier<Map> descriptionSupplier = () -> this.purchaseContextFieldManager.findDescriptions(purchaseContext).stream().filter(d -> d.getLocale().equals(locale.getLanguage())).collect(Collectors.toMap(PurchaseContextFieldDescription::getFieldName, d -> String.valueOf(d.getDescription().getOrDefault("label", d.getFieldName()))));
            ModelAndView mv = new ModelAndView();
            mv.getModelMap().addAllAttributes(model);
            mv.addObject("format-date", (Object)MustacheCustomTag.FORMAT_DATE);
            mv.addObject("country-name", (Object)MustacheCustomTag.COUNTRY_NAME);
            mv.addObject("render-markdown", (Object)MustacheCustomTag.RENDER_MARKDOWN);
            mv.addObject("additional-field-value", MustacheCustomTag.ADDITIONAL_FIELD_VALUE.apply(model.get(ADDITIONAL_FIELDS_KEY)));
            mv.addObject("print-additional-fields", MustacheCustomTag.PRINT_ADDITIONAL_FIELDS.apply(model.get(ADDITIONAL_FIELDS_KEY), descriptionSupplier));
            mv.addObject("metadata-value", MustacheCustomTag.ADDITIONAL_FIELD_VALUE.apply(model.get(METADATA_ATTRIBUTES_KEY)));
            mv.addObject("i18n", (Object)new CustomLocalizationMessageInterceptor(locale, messageSource).createTranslator());
            mv.addObject("discountCodeDescription", (Object)messageSource.getMessage("show-event.promo-code-type." + (usePartnerCode ? "partner" : "promotional"), null, locale));
            mv.addObject("subscriptionDescription", (Object)MustacheCustomTag.subscriptionDescriptionGenerator((MessageSource)messageSource, model, (Locale)locale));
            Map updatedModel = mv.getModel();
            updatedModel.putIfAbsent("custom-header-text", "");
            updatedModel.putIfAbsent("custom-body-text", "");
            updatedModel.putIfAbsent("custom-footer-text", "");
            boolean googleWalletEnabled = ((ConfigurationManager.MaybeConfiguration)configuration.get(ConfigurationKeys.ENABLE_WALLET)).getValueAsBooleanOrDefault();
            boolean appleWalletEnabled = ((ConfigurationManager.MaybeConfiguration)configuration.get(ConfigurationKeys.ENABLE_PASS)).getValueAsBooleanOrDefault();
            updatedModel.putIfAbsent("googleWalletEnabled", googleWalletEnabled);
            updatedModel.putIfAbsent("appleWalletEnabled", appleWalletEnabled);
            updatedModel.putIfAbsent("walletEnabled", googleWalletEnabled || appleWalletEnabled);
            return this.compile(resource, templateOutput).execute((Object)mv.getModel());
        }
        catch (Exception e) {
            log.error("TemplateManager: got exception while generating a template", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private Template compile(Resource resource, TemplateOutput templateOutput) {
        Template template;
        InputStreamReader tmpl = new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8);
        try {
            template = ((Mustache.Compiler)this.compilers.get(templateOutput)).compile((Reader)tmpl);
        }
        catch (Throwable throwable) {
            try {
                try {
                    tmpl.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new IllegalStateException(ioe);
            }
        }
        tmpl.close();
        return template;
    }

    private static String extractKey(String key) {
        Matcher matcher = KEY_PATTERN.matcher(key);
        if (matcher.find()) {
            return matcher.group(1).strip();
        }
        return key.strip();
    }

    private static List<String> extractParameters(String key) {
        Matcher matcher = ARGS_PATTERN.matcher(key);
        ArrayList<String> args = new ArrayList<String>();
        while (matcher.find()) {
            args.add(matcher.group(1));
        }
        return args;
    }

    public static String translate(String template, Locale locale, MessageSource messageSource) {
        StringBuilder sb = new StringBuilder(template.length());
        AST ast = new AST();
        ParserState state = ParserState.START;
        int idx = 0;
        do {
            Pair stateAndIdx = state.next(template, idx, ast);
            state = (ParserState)stateAndIdx.getKey();
            idx = (Integer)stateAndIdx.getValue();
        } while (state != ParserState.END);
        ast.visit(sb, locale, messageSource);
        return sb.toString();
    }
}

