/*
 * Decompiled with CFR 0.152.
 */
package alfio.util;

import alfio.controller.api.support.AdditionalServiceWithData;
import alfio.controller.api.support.Description;
import alfio.model.AdditionalServiceItem;
import alfio.model.AdditionalServiceText;
import alfio.model.CustomerName;
import alfio.model.Event;
import alfio.model.FieldConfigurationDescriptionAndValue;
import alfio.model.FieldNameAndValue;
import alfio.model.FileBlobMetadata;
import alfio.model.OrderSummary;
import alfio.model.PriceContainer;
import alfio.model.PurchaseContext;
import alfio.model.SummaryRow;
import alfio.model.Ticket;
import alfio.model.TicketCategory;
import alfio.model.TicketReservation;
import alfio.model.TicketReservationInfo;
import alfio.model.TicketWithCategory;
import alfio.model.TicketWithMetadataAttributes;
import alfio.model.TotalPrice;
import alfio.model.WaitingQueueSubscription;
import alfio.model.metadata.SubscriptionMetadata;
import alfio.model.modification.SendCodeModification;
import alfio.model.subscription.Subscription;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.model.transaction.PaymentMethod;
import alfio.model.transaction.PaymentProxy;
import alfio.model.user.Organization;
import alfio.util.ClockProvider;
import alfio.util.ImageUtil;
import alfio.util.MonetaryUtil;
import alfio.util.TemplateManager;
import alfio.util.TemplateResource;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 * Exception performing whole class analysis ignored.
 */
public enum TemplateResource {
    CONFIRMATION_EMAIL_FOR_ORGANIZER/* Unavailable Anonymous Inner Class!! */,
    SEND_RESERVED_CODE/* Unavailable Anonymous Inner Class!! */,
    CONFIRMATION_EMAIL/* Unavailable Anonymous Inner Class!! */,
    CONFIRMATION_EMAIL_SUBSCRIPTION/* Unavailable Anonymous Inner Class!! */,
    OFFLINE_RESERVATION_EXPIRED_EMAIL/* Unavailable Anonymous Inner Class!! */,
    CHARGE_ATTEMPT_FAILED_EMAIL/* Unavailable Anonymous Inner Class!! */,
    CHARGE_ATTEMPT_FAILED_EMAIL_FOR_ORGANIZER/* Unavailable Anonymous Inner Class!! */,
    CREDIT_NOTE_ISSUED_EMAIL/* Unavailable Anonymous Inner Class!! */,
    OFFLINE_RESERVATION_EXPIRING_EMAIL_FOR_ORGANIZER/* Unavailable Anonymous Inner Class!! */,
    OFFLINE_PAYMENT_MATCHES_FOUND/* Unavailable Anonymous Inner Class!! */,
    REMINDER_EMAIL/* Unavailable Anonymous Inner Class!! */,
    REMINDER_TICKET_ADDITIONAL_INFO/* Unavailable Anonymous Inner Class!! */,
    REMINDER_TICKETS_ASSIGNMENT_EMAIL/* Unavailable Anonymous Inner Class!! */,
    TICKET_EMAIL/* Unavailable Anonymous Inner Class!! */,
    TICKET_EMAIL_FOR_ONLINE_EVENT/* Unavailable Anonymous Inner Class!! */,
    TICKET_HAS_CHANGED_OWNER/* Unavailable Anonymous Inner Class!! */,
    TICKET_HAS_BEEN_CANCELLED/* Unavailable Anonymous Inner Class!! */,
    TICKET_HAS_BEEN_CANCELLED_ADMIN/* Unavailable Anonymous Inner Class!! */,
    TICKET_PDF/* Unavailable Anonymous Inner Class!! */,
    RECEIPT_PDF/* Unavailable Anonymous Inner Class!! */,
    INVOICE_PDF/* Unavailable Anonymous Inner Class!! */,
    CREDIT_NOTE_PDF/* Unavailable Anonymous Inner Class!! */,
    SUBSCRIPTION_PDF/* Unavailable Anonymous Inner Class!! */,
    WAITING_QUEUE_JOINED/* Unavailable Anonymous Inner Class!! */,
    WAITING_QUEUE_RESERVATION_EMAIL/* Unavailable Anonymous Inner Class!! */,
    CUSTOM_MESSAGE/* Unavailable Anonymous Inner Class!! */;

    public static final String FULL_NAME = "fullName";
    public static final String MULTIPART_ALTERNATIVE_MIMETYPE = "multipart/alternative";
    private static final String EVENT_NAME = "eventName";
    private static final String PLAIN_TEMPLATE_SUFFIX = "-txt.ms";
    private static final String HTML_TEMPLATE_SUFFIX = "-html.ms";
    private static final String TICKET_KEY = "ticket";
    private static final String RESERVATION_ID = "reservationId";
    private static final String RESERVATION_ID_VALUE = "597e7e7b-c514-4dcb-be8c-46cf7fe2c36e";
    private static final String IMAGE_WIDTH = "imageWidth";
    private static final String IMAGE_HEIGHT = "imageHeight";
    private static final String EVENT = "event";
    private static final String BASE_URL = "baseUrl";
    private static final String RESERVATION = "reservation";
    private static final String RESERVATION_URL = "reservationUrl";
    private static final String ORGANIZATION = "organization";
    private static final Pattern TICKET_UUID_FINDER;
    private static final UUID INTERNAL_UUID;
    private static final UUID PUBLIC_UUID;
    private final String classPathUrl;
    private final boolean overridable;
    private final String renderedContentType;
    private final TemplateManager.TemplateOutput templateOutput;
    private final PurchaseContext.PurchaseContextType purchaseContextType;

    private static SampleData buildTicket(Event purchaseContext) {
        ZonedDateTime now = purchaseContext.now(ClockProvider.clock());
        TicketCategory ticketCategory = new TicketCategory(0, now, now, 42, "Ticket", false, TicketCategory.Status.ACTIVE, purchaseContext.getId(), false, 1000, null, null, null, null, null, "CHF", Integer.valueOf(0), null, TicketCategory.TicketAccessType.INHERIT);
        return new SampleData(purchaseContext, ticketCategory);
    }

    private static byte[] replaceOldReferences(byte[] raw) {
        String contentAsString = new String(raw, StandardCharsets.UTF_8);
        return TICKET_UUID_FINDER.matcher(contentAsString).replaceAll("{{ticket.publicUuid}}").getBytes(StandardCharsets.UTF_8);
    }

    private TemplateResource(String classPathUrl, String renderedContentType, TemplateManager.TemplateOutput templateOutput) {
        this(string, n, classPathUrl, renderedContentType, templateOutput, PurchaseContext.PurchaseContextType.event);
    }

    private TemplateResource(String classPathUrl, String renderedContentType, TemplateManager.TemplateOutput templateOutput, PurchaseContext.PurchaseContextType purchaseContextType) {
        this.classPathUrl = classPathUrl;
        this.overridable = true;
        this.renderedContentType = renderedContentType;
        this.templateOutput = templateOutput;
        this.purchaseContextType = purchaseContextType;
    }

    public String getSavedName(Locale locale) {
        return this.name() + "_" + locale.getLanguage() + ".ms";
    }

    public boolean overridable() {
        return this.overridable;
    }

    public String classPath() {
        return this.isMultipart() ? this.classPathUrl + "-txt.ms" : this.classPathUrl;
    }

    public String htmlClassPath() {
        return this.isMultipart() ? this.classPathUrl + "-html.ms" : null;
    }

    public boolean isMultipart() {
        return "multipart/alternative".equals(this.renderedContentType);
    }

    public String getRenderedContentType() {
        return this.renderedContentType;
    }

    public TemplateManager.TemplateOutput getTemplateOutput() {
        return this.templateOutput;
    }

    public PurchaseContext.PurchaseContextType getPurchaseContextType() {
        return this.purchaseContextType;
    }

    public byte[] replaceTokens(byte[] raw) {
        return raw;
    }

    public Map<String, Object> prepareSampleModel(Organization organization, PurchaseContext event, Optional<ImageData> imageData) {
        return Collections.emptyMap();
    }

    private static Ticket sampleTicket(ZoneId zoneId) {
        return TemplateResource.sampleTicket((String)"Firstname", (String)"Lastname", (String)"email@email.tld", (ZoneId)zoneId);
    }

    private static Map<String, Object> sampleBillingDocument(Optional<ImageData> imageData, Organization organization, Event event) {
        Map model = TemplateResource.prepareSampleDataForConfirmationEmail((Organization)organization, (Event)event);
        imageData.ifPresent(iData -> {
            model.put("eventImage", iData.getEventImage());
            model.put("imageWidth", iData.getImageWidth());
            model.put("imageHeight", iData.getImageHeight());
        });
        return model;
    }

    private static TicketCategory sampleCategory(ZoneId zoneId) {
        Clock clock = ClockProvider.clock().withZone(zoneId);
        return new TicketCategory(0, ZonedDateTime.now(clock).minusDays(1L), ZonedDateTime.now(clock).plusDays(1L), 100, "test category", false, TicketCategory.Status.ACTIVE, 0, true, 100, null, null, null, null, null, "CHF", Integer.valueOf(0), null, TicketCategory.TicketAccessType.INHERIT);
    }

    private static Ticket sampleTicket(String firstName, String lastName, String email, ZoneId zoneId) {
        return new Ticket(0, INTERNAL_UUID.toString(), PUBLIC_UUID, ZonedDateTime.now(ClockProvider.clock().withZone(zoneId)), Integer.valueOf(0), "ACQUIRED", 0, "597e7e7b-c514-4dcb-be8c-46cf7fe2c36e", firstName + " " + lastName, firstName, lastName, email, false, "en", 1000, 1000, 80, 0, null, "CHF", List.of(), null, PriceContainer.VatStatus.INCLUDED);
    }

    private static TicketReservation sampleTicketReservation(ZoneId zoneId) {
        Clock clock = ClockProvider.clock().withZone(zoneId);
        return new TicketReservation("597e7e7b-c514-4dcb-be8c-46cf7fe2c36e", new Date(), TicketReservation.TicketReservationStatus.COMPLETE, "Firstname Lastname", "FirstName", "Lastname", "email@email.tld", "billing address", ZonedDateTime.now(clock), ZonedDateTime.now(clock), PaymentProxy.STRIPE, Boolean.valueOf(true), null, false, "en", false, null, null, null, "123456", "CH", false, new BigDecimal("8.00"), Boolean.valueOf(true), ZonedDateTime.now(clock).minusMinutes(1L), "PO-1234", ZonedDateTime.now(clock), Integer.valueOf(10000), Integer.valueOf(10800), Integer.valueOf(800), Integer.valueOf(0), "CHF");
    }

    private static Map<String, Object> prepareSampleDataForConfirmationEmail(Organization organization, Event event) {
        TicketReservation reservation = TemplateResource.sampleTicketReservation((ZoneId)event.getZoneId());
        Optional<String> vat = Optional.of("VAT-NR");
        List<TicketWithCategory> tickets = Collections.singletonList(new TicketWithCategory(TemplateResource.sampleTicket((ZoneId)event.getZoneId()), TemplateResource.sampleCategory((ZoneId)event.getZoneId())));
        OrderSummary orderSummary = new OrderSummary(new TotalPrice(1000, 80, 0, 0, "CHF"), List.of(new SummaryRow("Ticket", "10.00", "9.20", 1, "9.20", "9.20", 1000, SummaryRow.SummaryType.TICKET, null, PriceContainer.VatStatus.INCLUDED)), false, "10.00", "0.80", false, false, false, "8", PriceContainer.VatStatus.INCLUDED, "1.00");
        String baseUrl = "http://your-domain.tld";
        String reservationUrl = baseUrl + "/reservation-url/";
        String reservationShortId = "597e7e7b";
        return TemplateResource.prepareModelForConfirmationEmail((Organization)organization, (PurchaseContext)event, (TicketReservation)reservation, vat, tickets, (OrderSummary)orderSummary, (String)baseUrl, (String)reservationUrl, (String)reservationShortId, Optional.of("My Invoice\nAddress"), Optional.empty(), Optional.empty(), Map.of());
    }

    private static Map<String, Object> prepareSampleDataForChargeFailed(Organization organization, Event event) {
        TicketReservation reservation = TemplateResource.sampleTicketReservation((ZoneId)event.getZoneId());
        return Map.of("reservationId", reservation.getId().substring(0, 8), "reservationCancelled", true, "reservation", reservation, "eventName", event.getDisplayName(), "provider", PaymentMethod.CREDIT_CARD.name(), "reason", "this is the reason from the provider", "reservationUrl", "http://your-domain.tld/reservation-url/", "organization", organization);
    }

    public static Map<String, Object> prepareModelForConfirmationEmail(Organization organization, PurchaseContext purchaseContext, TicketReservation reservation, Optional<String> vat, List<TicketWithCategory> tickets, OrderSummary orderSummary, String baseUrl, String reservationUrl, String reservationShortID, Optional<String> invoiceAddress, Optional<String> bankAccountNr, Optional<String> bankAccountOwner, Map<String, Object> additionalModelObjects) {
        HashMap<String, Object> model = new HashMap<String, Object>(additionalModelObjects);
        model.put("organization", organization);
        model.put("event", purchaseContext.event().orElse(null));
        model.put("purchaseContext", purchaseContext);
        model.put("purchaseContextTitle", purchaseContext.getTitle().get(reservation.getUserLanguage()));
        model.put("ticketReservation", reservation);
        model.put("hasVat", vat.isPresent());
        model.put("vatNr", vat.orElse(""));
        model.put("tickets", tickets);
        model.put("orderSummary", orderSummary);
        model.put("publicId", reservationShortID);
        model.put("baseUrl", baseUrl);
        model.put("reservationUrl", reservationUrl);
        model.put("locale", reservation.getUserLanguage());
        model.put("hasRefund", StringUtils.isNotEmpty((CharSequence)orderSummary.getRefundedAmount()));
        ZoneId zoneId = purchaseContext.getZoneId();
        Clock clock = ClockProvider.clock().withZone(zoneId);
        ZonedDateTime creationTimestamp = (ZonedDateTime)ObjectUtils.firstNonNull((Object[])new ZonedDateTime[]{reservation.getRegistrationTimestamp(), reservation.getConfirmationTimestamp(), reservation.getCreationTimestamp(), ZonedDateTime.now(clock)});
        model.put("confirmationDate", creationTimestamp.withZoneSameInstant(zoneId));
        model.put("now", ZonedDateTime.now(clock));
        if (reservation.getValidity() != null) {
            model.put("expirationDate", ZonedDateTime.ofInstant(reservation.getValidity().toInstant(), zoneId));
        }
        model.put("reservationShortID", reservationShortID);
        model.put("hasInvoiceAddress", invoiceAddress.isPresent());
        invoiceAddress.ifPresent(addr -> {
            model.put("invoiceAddress", StringUtils.replace((String)addr, (String)"\n", (String)", "));
            model.put("invoiceAddressAsList", Arrays.asList(StringUtils.split((String)addr, (char)'\n')));
        });
        model.put("hasBankAccountNr", bankAccountNr.isPresent());
        bankAccountNr.ifPresent(nr -> model.put("bankAccountNr", nr));
        model.put("isOfflinePayment", reservation.getStatus() == TicketReservation.TicketReservationStatus.OFFLINE_PAYMENT);
        model.put("hasCustomerReference", StringUtils.isNotBlank((CharSequence)reservation.getCustomerReference()));
        model.put("paymentReason", reservationShortID);
        model.put("hasBankAccountOnwer", bankAccountOwner.isPresent());
        bankAccountOwner.ifPresent(owner -> {
            model.put("bankAccountOnwer", StringUtils.replace((String)owner, (String)"\n", (String)", "));
            model.put("bankAccountOnwerAsList", Arrays.asList(StringUtils.split((String)owner, (char)'\n')));
        });
        return model;
    }

    public static Map<String, Object> prepareModelForOfflineReservationExpiringEmailForOrganizer(Event event, List<TicketReservationInfo> reservations, String baseUrl) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("eventName", event.getDisplayName());
        model.put("ticketReservations", reservations.stream().map(r -> new TicketReservationWithZonedExpiringDate(r, event)).collect(Collectors.toList()));
        model.put("baseUrl", baseUrl);
        model.put("eventShortName", event.getShortName());
        return model;
    }

    private static Map<String, Object> prepareSampleModelForOfflineReservationExpiringEmailForOrganizer(Event event) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("eventName", event.getDisplayName());
        model.put("ticketReservations", Collections.singletonList(new TicketReservationInfo("id", null, "Firstname", "Lastname", "email@email.email", Integer.valueOf(1000), "EUR", 42, new Date())));
        model.put("baseUrl", "http://base-url/");
        model.put("eventShortName", event.getShortName());
        return model;
    }

    public static Map<String, Object> prepareModelForSendReservedCode(Organization organization, Event event, SendCodeModification m, String eventPageUrl, String promoCodeLabel) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("code", m.getCode());
        model.put("event", event);
        model.put("organization", organization);
        model.put("eventPage", eventPageUrl);
        model.put("assignee", m.getAssignee());
        model.put("promoCodeDescription", promoCodeLabel);
        return model;
    }

    public static Map<String, Object> prepareModelForReminderTicketAdditionalInfo(Organization organization, Event event, Ticket ticket, String ticketUrl) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("event", event);
        model.put("fullName", ticket.getFullName());
        model.put("organization", organization);
        model.put("ticketURL", ticketUrl);
        return model;
    }

    public static Map<String, Object> buildModelForTicketEmail(Organization organization, Event event, TicketReservation ticketReservation, String baseUrl, String ticketURL, String calendarURL, Ticket ticket, TicketCategory ticketCategory, Map<String, Object> additionalOptions) {
        HashMap<String, Object> model = new HashMap<String, Object>(additionalOptions);
        model.put("organization", organization);
        model.put("event", event);
        model.put("ticketReservation", ticketReservation);
        model.put("baseUrl", baseUrl);
        model.put("ticketUrl", ticketURL);
        model.put("ticket", ticket);
        model.put("googleCalendarUrl", calendarURL);
        TemplateResource.fillTicketValidity((Event)event, (TicketCategory)ticketCategory, model);
        return model;
    }

    public static void fillTicketValidity(Event event, TicketCategory ticketCategory, Map<String, Object> model) {
        model.put("validityStart", Optional.ofNullable(ticketCategory.getTicketValidityStart(event.getZoneId())).orElse(event.getBegin()));
        model.put("validityEnd", Optional.ofNullable(ticketCategory.getTicketValidityEnd(event.getZoneId())).orElse(event.getEnd()));
    }

    public static Map<String, Object> buildModelForTicketHasChangedOwner(Organization organization, Event e, Ticket oldTicket, Ticket newTicket, String ticketUrl) {
        HashMap<String, Object> emailModel = new HashMap<String, Object>();
        emailModel.put("ticket", oldTicket);
        emailModel.put("organization", organization);
        emailModel.put("eventName", e.getDisplayName());
        emailModel.put("previousEmail", oldTicket.getEmail());
        emailModel.put("newEmail", newTicket.getEmail());
        emailModel.put("ticketUrl", ticketUrl);
        return emailModel;
    }

    public static Map<String, Object> buildModelForTicketHasBeenCancelled(Organization organization, Event event, Ticket ticket) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("eventName", event.getDisplayName());
        model.put("ticket", ticket);
        model.put("organization", organization);
        return model;
    }

    public static Map<String, Object> buildModelForTicketHasBeenCancelledAdmin(Organization organization, Event event, Ticket ticket, String ticketCategoryDescription, List<AdditionalServiceItem> additionalServiceItems, Function<AdditionalServiceItem, Optional<AdditionalServiceText>> titleFinder) {
        Map model = TemplateResource.buildModelForTicketHasBeenCancelled((Organization)organization, (Event)event, (Ticket)ticket);
        model.put("ticketCategoryDescription", ticketCategoryDescription);
        model.put("hasAdditionalServices", !additionalServiceItems.isEmpty());
        model.put("additionalServices", additionalServiceItems.stream().map(asi -> {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("name", ((Optional)titleFinder.apply((AdditionalServiceItem)asi)).map(AdditionalServiceText::getValue).orElse("N/A"));
            data.put("amount", MonetaryUtil.centsToUnit((int)asi.getFinalPriceCts(), (String)asi.getCurrencyCode()).toString() + event.getCurrency());
            data.put("id", asi.getId());
            return data;
        }).collect(Collectors.toList()));
        return model;
    }

    public static Map<String, Object> buildModelForTicketPDF(Organization organization, Event event, TicketReservation ticketReservation, TicketCategory ticketCategory, TicketWithMetadataAttributes ticketWithMetadata, Optional<ImageData> imageData, String reservationId, Map<String, String> additionalFields, List<AdditionalServiceWithData> additionalServicesWithData) {
        String qrCodeText = ticketWithMetadata.getTicket().ticketCode(event.getPrivateKey(), event.supportsQRCodeCaseInsensitive());
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("ticket", ticketWithMetadata.getTicket());
        model.put("reservation", ticketReservation);
        model.put("ticketCategory", ticketCategory);
        model.put("event", event);
        model.put("organization", organization);
        model.put("reservationId", reservationId);
        model.put("additional-fields", additionalFields);
        model.put("metadata-attributes", ticketWithMetadata.getAttributes());
        TemplateResource.fillTicketValidity((Event)event, (TicketCategory)ticketCategory, model);
        model.put("qrCodeDataUri", "data:image/png;base64," + Base64.getEncoder().encodeToString(ImageUtil.createQRCode((String)qrCodeText)));
        imageData.ifPresent(iData -> {
            model.put("eventImage", iData.getEventImage());
            model.put("imageWidth", iData.getImageWidth());
            model.put("imageHeight", iData.getImageHeight());
        });
        model.put("deskPaymentRequired", Optional.ofNullable(ticketReservation.getPaymentMethod()).orElse(PaymentProxy.STRIPE).isDeskPaymentRequired());
        TemplateResource.fillAdditionalServices((TicketWithMetadataAttributes)ticketWithMetadata, additionalServicesWithData, model);
        return model;
    }

    private static void fillAdditionalServices(TicketWithMetadataAttributes ticketWithMetadata, List<AdditionalServiceWithData> additionalServicesWithData, Map<String, Object> model) {
        model.put("hasAdditionalServices", !additionalServicesWithData.isEmpty());
        Map<Integer, List<AdditionalServiceWithData>> byServiceId = additionalServicesWithData.stream().collect(Collectors.groupingBy(AdditionalServiceWithData::getServiceId));
        List<GroupedAdditionalServiceWithData> additionalServices = byServiceId.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> {
            AdditionalServiceWithData first = (AdditionalServiceWithData)((List)entry.getValue()).get(0);
            String userLanguage = ticketWithMetadata.getTicket().getUserLanguage();
            return new GroupedAdditionalServiceWithData(((List)entry.getValue()).size(), (String)first.getTitle().get(userLanguage), ((List)entry.getValue()).stream().flatMap(asw -> asw.getTicketFieldConfiguration().stream().filter(tfc -> StringUtils.isNotBlank((CharSequence)tfc.getValue())).map(tfc -> {
                String value = tfc.getRestrictedValues().stream().filter(rv -> rv.equals(tfc.getValue())).findFirst().orElse(tfc.getValue());
                return new FieldNameAndValue(((Description)tfc.getDescription().get(userLanguage)).getLabel(), value);
            })).toList());
        }).toList();
        model.put("additionalServices", additionalServices);
    }

    public static Map<String, Object> buildModelForSubscriptionPDF(Subscription subscription, SubscriptionDescriptor subscriptionDescriptor, Organization organization, SubscriptionMetadata metadata, Optional<ImageData> imageData, String reservationId, Locale locale, TicketReservation reservation, List<FieldConfigurationDescriptionAndValue> fields) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("title", subscriptionDescriptor.getLocalizedTitle(locale));
        model.put("validityTypeNotSet", subscriptionDescriptor.getValidityType() == SubscriptionDescriptor.SubscriptionValidityType.NOT_SET);
        model.put("validityTypeStandard", subscriptionDescriptor.getValidityType() == SubscriptionDescriptor.SubscriptionValidityType.STANDARD);
        model.put("validityTypeCustom", subscriptionDescriptor.getValidityType() == SubscriptionDescriptor.SubscriptionValidityType.CUSTOM);
        model.put("subscription", subscription);
        model.put("subscriptionDescriptor", subscriptionDescriptor);
        model.put("organization", organization);
        model.put("reservation", reservation);
        model.put("reservationId", reservationId);
        model.put("metadata-attributes", metadata.getProperties());
        model.put("displayPin", metadata.getConfiguration().isDisplayPin());
        imageData.ifPresent(iData -> {
            model.put("logo", iData.getEventImage());
            model.put("imageWidth", iData.getImageWidth());
            model.put("imageHeight", iData.getImageHeight());
        });
        model.put("additional-fields", fields.stream().collect(Collectors.toMap(FieldConfigurationDescriptionAndValue::getName, FieldConfigurationDescriptionAndValue::getValueDescription)));
        return model;
    }

    public static Map<String, Object> buildModelForWaitingQueueJoined(Organization organization, Event event, CustomerName name) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("eventName", event.getDisplayName());
        model.put("fullName", name.getFullName());
        model.put("organization", organization);
        return model;
    }

    public static Map<String, Object> buildModelForWaitingQueueReservationEmail(Organization organization, Event event, WaitingQueueSubscription subscription, String reservationUrl, ZonedDateTime expiration) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("event", event);
        model.put("subscription", subscription);
        model.put("reservationUrl", reservationUrl);
        model.put("reservationTimeout", expiration);
        model.put("organization", organization);
        return model;
    }

    public static ImageData fillWithImageData(FileBlobMetadata m, byte[] image) {
        Map attributes = m.getAttributes();
        if (attributes.containsKey("width") && attributes.containsKey("height")) {
            int width = Integer.parseInt((String)attributes.get("width"));
            int height = Integer.parseInt((String)attributes.get("height"));
            int resizedWidth = width;
            int resizedHeight = height;
            if (resizedHeight > 150) {
                resizedHeight = 150;
                resizedWidth = width * resizedHeight / height;
            }
            if (resizedWidth > 300) {
                resizedWidth = 300;
                resizedHeight = height * resizedWidth / width;
            }
            return new ImageData("data:" + m.getContentType() + ";base64," + Base64.getEncoder().encodeToString(image), Integer.valueOf(resizedWidth), Integer.valueOf(resizedHeight));
        }
        return new ImageData(null, null, null);
    }

    static {
        TICKET_UUID_FINDER = Pattern.compile("\\{\\{\\s*ticket\\.uuid\\s*}}", 8);
        INTERNAL_UUID = UUID.fromString("aaaaaaaa-0000-0000-0000-000000000000");
        PUBLIC_UUID = UUID.fromString("bbbbbbbb-0000-0000-0000-000000000000");
    }
}

