/*
 * Decompiled with CFR 0.152.
 */
package alfio.util;

import alfio.controller.form.AdditionalFieldsContainer;
import alfio.controller.form.AdditionalServiceLinkForm;
import alfio.controller.form.UpdateTicketOwnerForm;
import alfio.controller.form.WaitingQueueSubscriptionForm;
import alfio.manager.ExtensionManager;
import alfio.manager.SameCountryValidator;
import alfio.model.AdditionalServiceItem;
import alfio.model.ContentLanguage;
import alfio.model.Event;
import alfio.model.PurchaseContext;
import alfio.model.PurchaseContextFieldConfiguration;
import alfio.model.TicketCategory;
import alfio.model.modification.AdditionalFieldRequest;
import alfio.model.modification.DateTimeModification;
import alfio.model.modification.EventModification;
import alfio.model.modification.TicketCategoryModification;
import alfio.model.modification.support.LocationDescriptor;
import alfio.model.result.ErrorCode;
import alfio.model.result.Result;
import alfio.model.result.ValidationResult;
import alfio.util.ClockProvider;
import alfio.util.Validator;
import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.Period;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Validator {
    private static final Pattern SIMPLE_E_MAIL_PATTERN = Pattern.compile("^\\p{javaLetterOrDigit}[^\\s@]*@\\p{javaLetterOrDigit}[^\\s]*$");
    private static final Pattern CANONICAL_MAIL_VALIDATOR = Pattern.compile("^\\p{javaLetterOrDigit}[^\\s@]*@\\p{javaLetterOrDigit}[^\\s@]*\\.\\p{javaAlphabetic}{2,}$");
    private static final Pattern FIELD_NAME_VALIDATOR = Pattern.compile("^[a-zA-Z0-9][a-zA-Z0-9-_]*$");
    private static final String ERROR_DESCRIPTION = "error.description";
    private static final String EMAIL_KEY = "email";
    private static final String ERROR_EMAIL = "error.email";
    private static final String FIRST_NAME = "firstName";
    private static final String LAST_NAME = "lastName";
    private static final String FULL_NAME = "fullName";
    private static final String ADDITIONAL_PREFIX = "additional[";
    private static final String ADDITIONAL_SERVICES = "additionalServices";
    private static final String ERROR_RESTRICTED_VALUE = "error.restrictedValue";
    private static final Supplier<LocalDate> LOCAL_DATE_SUPPLIER = () -> LocalDate.now(ClockProvider.clock());
    private static final String DESCRIPTION = "description";
    private static final String TITLE = "title";

    private Validator() {
    }

    public static ValidationResult validateEventHeader(Optional<Event> event, EventModification ev, int descriptionMaxLength, Errors errors) {
        Map descriptions;
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"shortName", (String)"error.shortname");
        if (ev.getOrganizationId() < 0) {
            errors.rejectValue("organizationId", "error.organizationId");
        }
        if (Validator.allowsInPersonAccess(event, (EventModification)ev)) {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"location", (String)"error.location");
        }
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"websiteUrl", (String)"error.websiteurl");
        if (Validator.allowsInPersonAccess(event, (EventModification)ev) && Validator.isLocationMissing((EventModification)ev)) {
            errors.rejectValue("locationDescriptor", "error.coordinates");
        }
        if ((descriptions = ev.getDescription()) == null || descriptions.values().stream().anyMatch(v -> v == null || v.isBlank() || v.length() > descriptionMaxLength)) {
            errors.rejectValue("description", "error.description");
        }
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"termsAndConditionsUrl", (String)"error.termsandconditionsurl");
        if (ev.getFileBlobId() == null) {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"imageUrl", (String)"error.imageurl");
            if (!StringUtils.startsWith((CharSequence)ev.getImageUrl(), (CharSequence)"https://")) {
                errors.rejectValue("imageUrl", "error.imageurl");
            }
        }
        return Validator.evaluateValidationResult((Errors)errors);
    }

    private static boolean isLocationMissing(EventModification em) {
        LocationDescriptor descriptor = em.getLocationDescriptor();
        return descriptor == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{descriptor.getTimeZone()});
    }

    public static ValidationResult validateTicketCategories(EventModification ev, Errors errors) {
        if (CollectionUtils.isEmpty((Collection)ev.getTicketCategories())) {
            errors.rejectValue("ticketCategories", "error.ticketCategories");
        }
        if (ev.getTicketCategories().stream().anyMatch(tc -> tc.getTicketAccessType() == TicketCategory.TicketAccessType.INHERIT && ev.getFormat() == Event.EventFormat.HYBRID)) {
            errors.rejectValue("ticketCategories", "error.ticketCategories.format");
        }
        return Validator.evaluateValidationResult((Errors)errors);
    }

    public static ValidationResult validateEventDates(EventModification ev, Errors errors) {
        if (ev.getBegin() == null || ev.getBegin().getDate() == null || ev.getBegin().getTime() == null) {
            errors.rejectValue("begin", "error.beginDate");
        }
        if (ev.getEnd() == null || ev.getEnd().getDate() == null || ev.getEnd().getTime() == null) {
            errors.rejectValue("end", "error.endDate");
        }
        if (!errors.hasErrors() && !ev.getEnd().isAfter(ev.getBegin())) {
            errors.rejectValue("end", "error.endDate");
        }
        return Validator.evaluateValidationResult((Errors)errors);
    }

    public static ValidationResult validateEventPrices(EventModification ev, Errors errors) {
        if (!ev.isFreeOfCharge()) {
            if (Validator.isCollectionEmpty((Collection)ev.getAllowedPaymentProxies())) {
                errors.rejectValue("allowedPaymentProxies", "error.allowedpaymentproxies");
            }
            if (ev.getRegularPrice() == null || BigDecimal.ZERO.compareTo(ev.getRegularPrice()) >= 0) {
                errors.rejectValue("regularPrice", "error.regularprice");
            }
            if (ev.getVatPercentage() == null || BigDecimal.ZERO.compareTo(ev.getVatPercentage()) > 0) {
                errors.rejectValue("vatPercentage", "error.vat");
            }
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"currency", (String)"error.currency");
        }
        if (ev.getAvailableSeats() == null || ev.getAvailableSeats() < 1) {
            errors.rejectValue("availableSeats", "error.availableseats");
        }
        return Validator.evaluateValidationResult((Errors)errors);
    }

    public static ValidationResult validateCategory(TicketCategoryModification category, Errors errors, String prefix, EventModification eventModification, int descriptionMaxLength) {
        if (StringUtils.isBlank((CharSequence)category.getName())) {
            errors.rejectValue(prefix + "name", "error.category.name");
        }
        if (category.isBounded() && category.getMaxTickets() < 1) {
            errors.rejectValue(prefix + "maxTickets", "error.category.maxtickets");
        }
        if (!category.getInception().isBefore(category.getExpiration())) {
            errors.rejectValue(prefix + "dateString", "error.date");
        }
        if (eventModification != null && Validator.isCategoryExpirationAfterEventEnd((TicketCategoryModification)category, (EventModification)eventModification)) {
            errors.rejectValue(prefix + "expiration", "error.date.overflow");
        }
        if (Validator.isCategoryDescriptionTooLong((TicketCategoryModification)category, (int)descriptionMaxLength)) {
            errors.rejectValue(prefix + "description", "error.description");
        }
        return Validator.evaluateValidationResult((Errors)errors);
    }

    private static boolean isCategoryDescriptionTooLong(TicketCategoryModification category, int descriptionMaxLength) {
        return category.getDescription() != null && !category.getDescription().isEmpty() && category.getDescription().values().stream().filter(Objects::nonNull).anyMatch(v -> v.length() > descriptionMaxLength);
    }

    private static boolean isCategoryExpirationAfterEventEnd(TicketCategoryModification category, EventModification eventModification) {
        return eventModification.getEnd() == null || eventModification.getEnd().getDate() == null || category.getExpiration().isAfter(eventModification.getEnd());
    }

    public static ValidationResult validateCategory(TicketCategoryModification category, Errors errors, int descriptionMaxLength) {
        return Validator.validateCategory((TicketCategoryModification)category, (Errors)errors, (String)"", null, (int)descriptionMaxLength);
    }

    private static boolean isCollectionEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static ValidationResult evaluateValidationResult(Errors errors) {
        if (errors.hasFieldErrors()) {
            return ValidationResult.failed(errors.getFieldErrors().stream().map(ValidationResult.ErrorDescriptor::fromFieldError).toList());
        }
        return ValidationResult.success();
    }

    public static ValidationResult performAdvancedValidation(AdvancedTicketAssignmentValidator advancedValidator, AdvancedValidationContext context, Errors errors) {
        if (errors == null) {
            return ValidationResult.success();
        }
        Result advancedValidation = advancedValidator.apply(context);
        if (!advancedValidation.isSuccess()) {
            ErrorCode error = advancedValidation.getFirstErrorOrNull();
            Validate.notNull((Object)error, (String)"unexpected error", (Object[])new Object[0]);
            errors.rejectValue(StringUtils.defaultString((String)context.prefix) + error.getDescription(), error.getCode());
        }
        return Validator.evaluateValidationResult((Errors)errors);
    }

    public static ValidationResult validateTicketAssignment(UpdateTicketOwnerForm form, List<PurchaseContextFieldConfiguration> additionalFieldsForTicket, Optional<BindingResult> errorsOptional, Event event, String baseField, SameCountryValidator vatValidator, ExtensionManager extensionManager) {
        if (errorsOptional.isEmpty()) {
            return ValidationResult.success();
        }
        Object prefix = StringUtils.trimToEmpty((String)baseField);
        if (!((String)prefix).isEmpty() && !((String)prefix).endsWith(".")) {
            prefix = (String)prefix + ".";
        }
        BindingResult errors = errorsOptional.get();
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)((String)prefix + "email"), (String)"error.email");
        String email = form.getEmail();
        if (!Validator.isEmailValid((String)email)) {
            errors.rejectValue((String)prefix + "email", "error.email");
        }
        if (event.mustUseFirstAndLastName()) {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)((String)prefix + "firstName"), (String)"error.STEP_2_EMPTY_FIRSTNAME");
            Validator.validateMaxLength((String)form.getFirstName(), (String)((String)prefix + "firstName"), (String)"error.STEP_2_MAX_LENGTH_FIRSTNAME", (int)255, (Errors)errors);
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)((String)prefix + "lastName"), (String)"error.STEP_2_EMPTY_LASTNAME");
            Validator.validateMaxLength((String)form.getLastName(), (String)((String)prefix + "lastName"), (String)"error.STEP_2_MAX_LENGTH_LASTNAME", (int)255, (Errors)errors);
        } else {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)((String)prefix + "fullName"), (String)"error.STEP_2_EMPTY_FULLNAME");
            Validator.validateMaxLength((String)form.getFullName(), (String)((String)prefix + "fullName"), (String)"error.STEP_2_MAX_LENGTH_FULLNAME", (int)255, (Errors)errors);
        }
        Object prefixForLambda = prefix;
        for (PurchaseContextFieldConfiguration fieldConf : additionalFieldsForTicket) {
            Validator.validateFieldConfiguration((AdditionalFieldsContainer)form, (SameCountryValidator)vatValidator, (Errors)errors, (String)prefixForLambda, (PurchaseContextFieldConfiguration)fieldConf);
        }
        if (!errors.hasErrors()) {
            extensionManager.handleTicketUpdateValidation((PurchaseContext)event, form, errors, (String)prefix);
        }
        return Validator.evaluateValidationResult((Errors)errors);
    }

    public static ValidationResult validateAdditionalItemFieldsForTicket(AdditionalServiceLinkForm form, List<PurchaseContextFieldConfiguration> additionalFieldsForTicket, BindingResult errors, String prefix, SameCountryValidator vatValidator, List<AdditionalServiceLinkForm> allForms, List<AdditionalServiceItem> additionalServiceItems) {
        Set allKeys = allForms.stream().flatMap(f -> f.getAdditional().keySet().stream()).collect(Collectors.toSet());
        Set foundKeys = additionalFieldsForTicket.stream().map(PurchaseContextFieldConfiguration::getName).filter(allKeys::contains).collect(Collectors.toSet());
        for (PurchaseContextFieldConfiguration fieldConf : additionalFieldsForTicket) {
            Validator.validateFieldConfiguration((AdditionalFieldsContainer)form, (SameCountryValidator)vatValidator, (Errors)errors, (String)(prefix + "."), (PurchaseContextFieldConfiguration)fieldConf, (boolean)foundKeys.contains(fieldConf.getName()));
        }
        return Validator.evaluateValidationResult((Errors)errors);
    }

    public static void validateFieldConfiguration(AdditionalFieldsContainer form, SameCountryValidator vatValidator, Errors errors, String prefixForLambda, PurchaseContextFieldConfiguration fieldConf) {
        Validator.validateFieldConfiguration((AdditionalFieldsContainer)form, (SameCountryValidator)vatValidator, (Errors)errors, (String)prefixForLambda, (PurchaseContextFieldConfiguration)fieldConf, (boolean)false);
    }

    private static void validateFieldConfiguration(AdditionalFieldsContainer form, SameCountryValidator vatValidator, Errors errors, String prefixForLambda, PurchaseContextFieldConfiguration fieldConf, boolean skipPresenceCheck) {
        boolean isFieldPresent;
        boolean bl = isFieldPresent = form.getAdditional() != null && form.getAdditional().containsKey(fieldConf.getName());
        if (!skipPresenceCheck && !isFieldPresent) {
            if (fieldConf.isRequired()) {
                if (form.getAdditional() == null) {
                    form.setAdditional(new HashMap());
                }
                form.getAdditional().put(fieldConf.getName(), Collections.singletonList(""));
                errors.rejectValue(prefixForLambda + "additional[" + fieldConf.getName() + "][0]", "error.emptyField");
            }
            return;
        }
        List values = form.getAdditional().computeIfAbsent(fieldConf.getName(), k -> List.of());
        if (fieldConf.isRequired() && fieldConf.getCount() > 1 && values.stream().allMatch(StringUtils::isBlank)) {
            errors.rejectValue(prefixForLambda + "additional[" + fieldConf.getName() + "]", "error.emptyField");
        }
        for (int i = 0; i < values.size(); ++i) {
            Validator.validateFieldValue((SameCountryValidator)vatValidator, (Errors)errors, (String)prefixForLambda, (PurchaseContextFieldConfiguration)fieldConf, (List)values, (int)i);
        }
    }

    private static void validateFieldValue(SameCountryValidator vatValidator, Errors errors, String prefixForLambda, PurchaseContextFieldConfiguration fieldConf, List<String> values, int i) {
        String formValue = values.get(i);
        Validator.fieldValueBasicValidation((Errors)errors, (String)prefixForLambda, (PurchaseContextFieldConfiguration)fieldConf, (int)i, (String)formValue);
        try {
            if (fieldConf.isEuVat() && !vatValidator.test(formValue)) {
                errors.rejectValue(prefixForLambda + "additional[" + fieldConf.getName() + "][" + i + "]", "error.STEP_2_INVALID_VAT");
            }
        }
        catch (IllegalStateException e) {
            errors.rejectValue(prefixForLambda + "additional[" + fieldConf.getName() + "][" + i + "]", "error.vatVIESDown");
        }
    }

    private static void fieldValueBasicValidation(Errors errors, String prefixForLambda, PurchaseContextFieldConfiguration fieldConf, int i, String formValue) {
        int age;
        Validator.validateLength((Errors)errors, (String)prefixForLambda, (PurchaseContextFieldConfiguration)fieldConf, (int)i, (String)formValue);
        if (!fieldConf.getRestrictedValues().isEmpty()) {
            Validator.validateRestrictedValue((String)formValue, (String)(prefixForLambda + "additional[" + fieldConf.getName() + "][" + i + "]"), (String)"error.restrictedValue", (List)fieldConf.getRestrictedValues(), (Errors)errors);
        }
        if (fieldConf.isRequired() && fieldConf.getCount() == 1 && StringUtils.isBlank((CharSequence)formValue)) {
            errors.rejectValue(prefixForLambda + "additional[" + fieldConf.getName() + "][" + i + "]", "error.emptyField");
        }
        if (fieldConf.hasDisabledValues() && fieldConf.getDisabledValues().contains(formValue)) {
            errors.rejectValue(prefixForLambda + "additional[" + fieldConf.getName() + "][" + i + "]", "error.disabledValue", null, null);
        }
        if (!errors.hasFieldErrors() && StringUtils.isNotBlank((CharSequence)formValue) && fieldConf.isDateOfBirth() && (age = Validator.calculateAge((String)formValue, (boolean)true, (Supplier)LOCAL_DATE_SUPPLIER)) < 0) {
            errors.rejectValue(prefixForLambda + "additional[" + fieldConf.getName() + "][" + i + "]", "error.emptyField");
        }
    }

    private static void validateLength(Errors errors, String prefixForLambda, PurchaseContextFieldConfiguration fieldConf, int fieldIndex, String formValue) {
        boolean isDateOfBirth = fieldConf.isDateOfBirth();
        if (isDateOfBirth) {
            Validator.validateDateInThePast((String)formValue, (String)(prefixForLambda + "additional[" + fieldConf.getName() + "][" + fieldIndex + "]"), (Errors)errors);
        }
        if (fieldConf.isMaxLengthDefined()) {
            Validator.validateMaxLength((String)formValue, (String)(prefixForLambda + "additional[" + fieldConf.getName() + "][" + fieldIndex + "]"), (String)(isDateOfBirth ? "error.tooOld" : "error.tooLong"), (PurchaseContextFieldConfiguration)fieldConf, (Errors)errors);
        }
        if (StringUtils.isNotBlank((CharSequence)formValue) && fieldConf.isMinLengthDefined()) {
            Validator.validateMinLength((String)formValue, (String)(prefixForLambda + "additional[" + fieldConf.getName() + "][" + fieldIndex + "]"), (String)(isDateOfBirth ? "error.tooYoung" : "error.tooShort"), (PurchaseContextFieldConfiguration)fieldConf, (Errors)errors);
        }
    }

    private static void validateRestrictedValue(String value, String fieldName, String errorCode, List<String> restrictedValues, Errors errors) {
        if (StringUtils.isNotBlank((CharSequence)value) && !restrictedValues.contains(value)) {
            errors.rejectValue(fieldName, errorCode);
        }
    }

    private static boolean allowsInPersonAccess(Optional<Event> event, EventModification ev) {
        return event.map(Event::getFormat).orElse(ev.getFormat()) != Event.EventFormat.ONLINE;
    }

    public static boolean isEmailValid(String email) {
        return StringUtils.isNotEmpty((CharSequence)email) && !email.strip().endsWith(".") && SIMPLE_E_MAIL_PATTERN.matcher(email).matches();
    }

    public static boolean isCanonicalMailAddress(String email) {
        return StringUtils.isNotEmpty((CharSequence)email) && CANONICAL_MAIL_VALIDATOR.matcher(email).matches();
    }

    private static void validateMinLength(String value, String fieldName, String errorCode, PurchaseContextFieldConfiguration fieldConfiguration, Errors errors) {
        if (fieldConfiguration.isDateOfBirth()) {
            Validator.validateMinAge((String)value, (String)fieldName, (String)errorCode, (PurchaseContextFieldConfiguration)fieldConfiguration, (Errors)errors);
        } else if (StringUtils.length((CharSequence)value) < fieldConfiguration.getMinLength()) {
            errors.rejectValue(fieldName, errorCode, new Object[]{fieldConfiguration.getMinLength()}, null);
        }
    }

    static void validateMinAge(String value, String fieldName, String errorCode, PurchaseContextFieldConfiguration fieldConfiguration, Errors errors) {
        Validator.validateMinAge((String)value, (String)fieldName, (String)errorCode, (PurchaseContextFieldConfiguration)fieldConfiguration, (Errors)errors, (Supplier)LOCAL_DATE_SUPPLIER);
    }

    static void validateMinAge(String value, String fieldName, String errorCode, PurchaseContextFieldConfiguration fieldConfiguration, Errors errors, Supplier<LocalDate> currentDateSupplier) {
        int minAge = fieldConfiguration.getMinLength();
        int age = Validator.calculateAge((String)value, (boolean)false, currentDateSupplier);
        if (age >= 0 && age < minAge) {
            errors.rejectValue(fieldName, errorCode, new Object[]{minAge}, null);
        }
    }

    static void validateDateInThePast(String value, String fieldName, Errors errors) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        try {
            Period period = Period.between(LocalDate.parse(value), LocalDate.now(ClockProvider.clock()));
            if (period.isNegative() || period.isZero()) {
                errors.rejectValue(fieldName, "error.restrictedValue", null, null);
            }
        }
        catch (DateTimeException dex) {
            errors.rejectValue(fieldName, "error.restrictedValue", null, null);
        }
    }

    private static void validateMaxLength(String value, String fieldName, String errorCode, PurchaseContextFieldConfiguration fieldConfiguration, Errors errors) {
        if (fieldConfiguration.isDateOfBirth()) {
            Validator.validateMaxAge((String)value, (String)fieldName, (String)errorCode, (PurchaseContextFieldConfiguration)fieldConfiguration, (Errors)errors);
        } else {
            Validator.validateMaxLength((String)value, (String)fieldName, (String)errorCode, (int)fieldConfiguration.getMaxLength(), (Errors)errors);
        }
    }

    static void validateMaxAge(String value, String fieldName, String errorCode, PurchaseContextFieldConfiguration fieldConfiguration, Errors errors) {
        Validator.validateMaxAge((String)value, (String)fieldName, (String)errorCode, (PurchaseContextFieldConfiguration)fieldConfiguration, (Errors)errors, (Supplier)LOCAL_DATE_SUPPLIER);
    }

    static void validateMaxAge(String value, String fieldName, String errorCode, PurchaseContextFieldConfiguration fieldConfiguration, Errors errors, Supplier<LocalDate> localDateSupplier) {
        int maxAge = fieldConfiguration.getMaxLength();
        int age = Validator.calculateAge((String)value, (boolean)true, localDateSupplier);
        if (age > maxAge) {
            errors.rejectValue(fieldName, errorCode, new Object[]{maxAge}, null);
        }
    }

    private static int calculateAge(String value, boolean addRemainder, Supplier<LocalDate> currentDateSupplier) {
        try {
            Period period = Period.between(LocalDate.parse(value), currentDateSupplier.get());
            int years = period.getYears();
            if (addRemainder && (period.getMonths() > 0 || period.getDays() > 0)) {
                ++years;
            }
            return years;
        }
        catch (DateTimeException ex) {
            return -1;
        }
    }

    private static void validateMaxLength(String value, String fieldName, String errorCode, int maxLength, Errors errors) {
        if (StringUtils.isNotBlank((CharSequence)value) && StringUtils.length((CharSequence)value) > maxLength) {
            errors.rejectValue(fieldName, errorCode, new Object[]{maxLength}, null);
        }
    }

    public static ValidationResult validateWaitingQueueSubscription(WaitingQueueSubscriptionForm form, Errors errors, Event event) {
        if (!form.isTermAndConditionsAccepted()) {
            errors.rejectValue("termAndConditionsAccepted", "error.STEP_2_TERMS_CONDITIONS");
        }
        if (StringUtils.isNotEmpty((CharSequence)event.getPrivacyPolicyUrl()) && !form.isPrivacyPolicyAccepted()) {
            errors.rejectValue("privacyPolicyAccepted", "error.STEP_2_TERMS_CONDITIONS");
        }
        if (event.mustUseFirstAndLastName()) {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"firstName", (String)"error.firstname");
            Validator.validateMaxLength((String)form.getFirstName(), (String)"firstName", (String)"error.firstname", (int)255, (Errors)errors);
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"lastName", (String)"lastname.fullname");
            Validator.validateMaxLength((String)form.getLastName(), (String)"lastName", (String)"error.lastname", (int)255, (Errors)errors);
        } else {
            Validator.validateMaxLength((String)form.getFullName(), (String)"fullName", (String)"error.fullname", (int)255, (Errors)errors);
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"fullName", (String)"error.fullname");
        }
        if (!Validator.isEmailValid((String)form.getEmail())) {
            errors.rejectValue("email", "error.email");
        }
        if (form.getUserLanguage() == null) {
            errors.rejectValue("userLanguage", "error.userLanguage");
        }
        return Validator.evaluateValidationResult((Errors)errors);
    }

    public static ValidationResult validateAdditionalService(EventModification.AdditionalService additionalService, Errors errors) {
        return Validator.validateAdditionalService((EventModification.AdditionalService)additionalService, null, (Errors)errors);
    }

    public static ValidationResult validateAdditionalService(EventModification.AdditionalService additionalService, EventModification eventModification, Errors errors) {
        boolean eventModificationIsNotNull;
        boolean bl = eventModificationIsNotNull = eventModification != null;
        if (additionalService.isFixPrice() && Optional.ofNullable(additionalService.getPrice()).filter(p -> p.compareTo(BigDecimal.ZERO) >= 0).isEmpty()) {
            Validator.rejectFieldForAdditionalService((String)"price", (boolean)eventModificationIsNotNull, (Errors)errors);
        }
        List descriptions = additionalService.getDescription();
        List titles = additionalService.getTitle();
        if (descriptions == null || titles == null || titles.size() != descriptions.size()) {
            Validator.rejectFieldForAdditionalService((String)"title", (boolean)eventModificationIsNotNull, (Errors)errors);
            Validator.rejectFieldForAdditionalService((String)"description", (boolean)eventModificationIsNotNull, (Errors)errors);
        } else {
            if (!Validator.validateDescriptionList((List)titles) || !Validator.containsAllRequiredTranslations((EventModification)eventModification, (List)titles)) {
                Validator.rejectFieldForAdditionalService((String)"title", (boolean)eventModificationIsNotNull, (Errors)errors);
            }
            if (!Validator.validateDescriptionList((List)descriptions) || !Validator.containsAllRequiredTranslations((EventModification)eventModification, (List)descriptions)) {
                Validator.rejectFieldForAdditionalService((String)"description", (boolean)eventModificationIsNotNull, (Errors)errors);
            }
        }
        DateTimeModification inception = additionalService.getInception();
        DateTimeModification expiration = additionalService.getExpiration();
        if (inception == null || expiration == null || expiration.isBefore(inception)) {
            Validator.rejectFieldForAdditionalService((String)"inception", (boolean)eventModificationIsNotNull, (Errors)errors);
            Validator.rejectFieldForAdditionalService((String)"expiration", (boolean)eventModificationIsNotNull, (Errors)errors);
        } else if (eventModification != null && expiration.isAfter(eventModification.getEnd())) {
            Validator.rejectFieldForAdditionalService((String)"expiration", (boolean)true, (Errors)errors);
        }
        return Validator.evaluateValidationResult((Errors)errors);
    }

    private static void rejectFieldForAdditionalService(String field, boolean eventModification, Errors errors) {
        String errorField = eventModification ? "additionalServices" : field;
        errors.rejectValue(errorField, "error." + field);
    }

    private static boolean containsAllRequiredTranslations(EventModification eventModification, List<EventModification.AdditionalServiceText> descriptions) {
        Optional<EventModification> optional = Optional.ofNullable(eventModification);
        return optional.isEmpty() || optional.map(e -> ContentLanguage.findAllFor((int)e.getLocales())).filter(l -> l.stream().allMatch(l1 -> descriptions.stream().anyMatch(d -> d.getLocale().equals(l1.getLanguage())))).isPresent();
    }

    private static boolean validateDescriptionList(List<EventModification.AdditionalServiceText> descriptions) {
        return descriptions.stream().allMatch(t -> StringUtils.isNotBlank((CharSequence)t.getValue()));
    }

    public static ValidationResult validateAdditionalFields(List<PurchaseContextFieldConfiguration> fieldConf, AdditionalFieldRequest field, Errors errors) {
        String duplicateName = fieldConf.stream().map(PurchaseContextFieldConfiguration::getName).filter(name -> name.equalsIgnoreCase(field.getName())).findAny().orElse("");
        if (StringUtils.isNotBlank((CharSequence)duplicateName)) {
            errors.rejectValue("name", "duplicate");
        } else if (!Validator.validateAdditionalInfoName((String)field.getName())) {
            errors.rejectValue("name", "pattern");
        }
        return Validator.evaluateValidationResult((Errors)errors);
    }

    public static boolean validateAdditionalInfoName(String additionalInfoName) {
        return FIELD_NAME_VALIDATOR.matcher(additionalInfoName).matches();
    }
}

