/*
 * Decompiled with CFR 0.152.
 */
package alfio.util;

import alfio.util.HoursRange;
import java.time.DayOfWeek;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;

/*
 * Exception performing whole class analysis ignored.
 */
public class WorkingDaysAdjusters {
    private static final Set<DayOfWeek> MON_FRI = EnumSet.complementOf(EnumSet.of(DayOfWeek.SATURDAY, DayOfWeek.SUNDAY));
    private static final List<HoursRange> ALL_DAY = Collections.singletonList(new HoursRange(LocalTime.of(8, 0, 0), LocalTime.of(20, 0, 0)));

    private WorkingDaysAdjusters() {
    }

    public static TemporalAdjuster defaultWorkingDays() {
        return temporal -> WorkingDaysAdjusters.adjust((Temporal)temporal, (Set)MON_FRI, (List)ALL_DAY);
    }

    public static Temporal addDays(Temporal start, int days) {
        Temporal end = start;
        for (int i = 0; i < days; ++i) {
            end = WorkingDaysAdjusters.adjust((Temporal)end.plus(1L, ChronoUnit.DAYS), (Set)MON_FRI, (List)ALL_DAY);
        }
        return end;
    }

    private static Temporal adjust(Temporal in, Set<DayOfWeek> dayOfWeeks, List<HoursRange> hoursRanges) {
        DayOfWeek dayOfWeek = DayOfWeek.from(in);
        LocalTime localTime = LocalTime.from(in);
        boolean dayInRange = dayOfWeeks.contains(dayOfWeek);
        boolean hourInRange = hoursRanges.stream().anyMatch(hr -> hr.includes(localTime));
        if (dayInRange && hourInRange) {
            return in;
        }
        Temporal result = in;
        if (!dayInRange) {
            while (!dayOfWeeks.contains(DayOfWeek.from(result = result.plus(1L, ChronoUnit.DAYS)))) {
            }
        }
        if (!hourInRange) {
            OptionalInt distance = hoursRanges.stream().mapToInt(hr -> hr.getDistanceInHours(localTime)).sorted().findFirst();
            result = result.plus(distance.orElseThrow(IllegalStateException::new), ChronoUnit.HOURS);
        }
        return result;
    }
}

