/*
 * Decompiled with CFR 0.152.
 */
package alfio.util;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;

public class Wrappers {
    private static final Logger log = LoggerFactory.getLogger(Wrappers.class);

    private Wrappers() {
    }

    public static <I> void voidTransactionWrapper(Consumer<I> consumer, I input) {
        try {
            consumer.accept(input);
        }
        catch (Exception ex) {
            log.error("Unexpected exception", (Throwable)ex);
        }
    }

    public static <T> Optional<T> safeSupplier(Supplier<T> supplier) {
        try {
            return Optional.ofNullable(supplier.get());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static <T> Optional<T> optionally(Supplier<T> s) {
        try {
            return Optional.ofNullable(s.get());
        }
        catch (IllegalArgumentException | IllegalStateException | EmptyResultDataAccessException e) {
            return Optional.empty();
        }
    }
}

