/*
 * Decompiled with CFR 0.152.
 */
package alfio.util.checkin;

import alfio.manager.ExtensionManager;
import alfio.manager.system.ConfigurationManager;
import alfio.model.Event;
import alfio.model.LocalizedContent;
import alfio.model.PurchaseContext;
import alfio.model.Ticket;
import alfio.model.TicketCategory;
import alfio.model.metadata.JoinLink;
import alfio.model.metadata.TicketMetadata;
import alfio.repository.EventRepository;
import alfio.repository.TicketCategoryRepository;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class TicketCheckInUtil {
    public static final String CUSTOM_CHECK_IN_URL = "customCheckInUrl";
    public static final String ONLINE_CHECK_IN_URL = "onlineCheckInUrl";
    public static final String CUSTOM_CHECK_IN_URL_TEXT = "customCheckInUrlText";
    public static final String CUSTOM_CHECK_IN_URL_DESCRIPTION = "customCheckInUrlDescription";

    private TicketCheckInUtil() {
    }

    public static String ticketOnlineCheckInUrl(Event event, Ticket ticket, String baseUrl) {
        String ticketCode = DigestUtils.sha256Hex((String)ticket.ticketCode(event.getPrivateKey(), event.supportsQRCodeCaseInsensitive()));
        return StringUtils.removeEnd((String)baseUrl, (String)"/") + "/event/" + event.getShortName() + "/ticket/" + ticket.getPublicUuid() + "/check-in/" + ticketCode;
    }

    public static Map<String, String> getOnlineCheckInInfo(ExtensionManager extensionManager, EventRepository eventRepository, TicketCategoryRepository ticketCategoryRepository, ConfigurationManager configurationManager, Event event, Locale ticketLanguage, Ticket ticket, TicketCategory ticketCategory, Map<String, List<String>> ticketAdditionalInfo) {
        HashMap<String, String> result = new HashMap<String, String>();
        Optional customMetadataOptional = extensionManager.handleCustomOnlineJoinUrl(event, ticket, ticketAdditionalInfo);
        result.put("customCheckInUrl", Boolean.toString(customMetadataOptional.isPresent()));
        if (customMetadataOptional.isPresent()) {
            TicketMetadata ticketMetadata = (TicketMetadata)customMetadataOptional.get();
            JoinLink joinLink = ticketMetadata.getJoinLink();
            result.put("onlineCheckInUrl", joinLink.getLink());
            if (joinLink.hasLinkText()) {
                result.put("customCheckInUrlText", joinLink.getLocalizedText(ticketLanguage.getLanguage(), (LocalizedContent)event));
            }
            String linkDescription = ticketMetadata.getLocalizedDescription(ticketLanguage.getLanguage(), (LocalizedContent)event);
            result.put("customCheckInUrlDescription", linkDescription);
            result.put("prerequisites", "");
        } else {
            Supplier<Optional> eventMetadata = () -> Optional.ofNullable(eventRepository.getMetadataForEvent(event.getId()).getRequirementsDescriptions()).flatMap(m -> Optional.ofNullable((String)m.get(ticketLanguage.getLanguage())));
            Optional categoryMetadata = Optional.ofNullable(ticketCategoryRepository.getMetadata(event.getId(), ticketCategory.getId()).getRequirementsDescriptions()).flatMap(m -> Optional.ofNullable((String)m.get(ticketLanguage.getLanguage())));
            result.put("onlineCheckInUrl", TicketCheckInUtil.ticketOnlineCheckInUrl((Event)event, (Ticket)ticket, (String)configurationManager.baseUrl((PurchaseContext)event)));
            result.put("prerequisites", categoryMetadata.or(eventMetadata).orElse(""));
        }
        return result;
    }
}

